package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountTakeoverRiskConfigurationType(
    notifyConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.NotifyConfigurationType
    ] = Optional.Absent,
    actions: zio.aws.cognitoidentityprovider.model.AccountTakeoverActionsType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType = {
    import AccountTakeoverRiskConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType
      .builder()
      .optionallyWith(notifyConfiguration.map(value => value.buildAwsValue()))(
        _.notifyConfiguration
      )
      .actions(actions.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType
      .wrap(buildAwsValue())
}
object AccountTakeoverRiskConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType =
      zio.aws.cognitoidentityprovider.model
        .AccountTakeoverRiskConfigurationType(
          notifyConfiguration.map(value => value.asEditable),
          actions.asEditable
        )
    def notifyConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.NotifyConfigurationType.ReadOnly
    ]
    def actions
        : zio.aws.cognitoidentityprovider.model.AccountTakeoverActionsType.ReadOnly
    def getNotifyConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.NotifyConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("notifyConfiguration", notifyConfiguration)
    def getActions: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionsType.ReadOnly
    ] = ZIO.succeed(actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType.ReadOnly {
    override val notifyConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.NotifyConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.notifyConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.NotifyConfigurationType
          .wrap(value)
      )
    override val actions
        : zio.aws.cognitoidentityprovider.model.AccountTakeoverActionsType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.AccountTakeoverActionsType
        .wrap(impl.actions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType
  ): zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType.ReadOnly =
    new Wrapper(impl)
}
