package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  EmailVerificationSubjectType,
  EmailVerificationMessageType,
  SmsVerificationMessageType
}
import scala.jdk.CollectionConverters._
final case class MessageTemplateType(
    smsMessage: Optional[SmsVerificationMessageType] = Optional.Absent,
    emailMessage: Optional[EmailVerificationMessageType] = Optional.Absent,
    emailSubject: Optional[EmailVerificationSubjectType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.MessageTemplateType = {
    import MessageTemplateType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.MessageTemplateType
      .builder()
      .optionallyWith(
        smsMessage.map(value =>
          SmsVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.smsMessage)
      .optionallyWith(
        emailMessage.map(value =>
          EmailVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.emailMessage)
      .optionallyWith(
        emailSubject.map(value =>
          EmailVerificationSubjectType.unwrap(value): java.lang.String
        )
      )(_.emailSubject)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.MessageTemplateType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.MessageTemplateType
      .wrap(buildAwsValue())
}
object MessageTemplateType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.MessageTemplateType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.MessageTemplateType =
      zio.aws.cognitoidentityprovider.model.MessageTemplateType(
        smsMessage.map(value => value),
        emailMessage.map(value => value),
        emailSubject.map(value => value)
      )
    def smsMessage: Optional[SmsVerificationMessageType]
    def emailMessage: Optional[EmailVerificationMessageType]
    def emailSubject: Optional[EmailVerificationSubjectType]
    def getSmsMessage: ZIO[Any, AwsError, SmsVerificationMessageType] =
      AwsError.unwrapOptionField("smsMessage", smsMessage)
    def getEmailMessage: ZIO[Any, AwsError, EmailVerificationMessageType] =
      AwsError.unwrapOptionField("emailMessage", emailMessage)
    def getEmailSubject: ZIO[Any, AwsError, EmailVerificationSubjectType] =
      AwsError.unwrapOptionField("emailSubject", emailSubject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.MessageTemplateType
  ) extends zio.aws.cognitoidentityprovider.model.MessageTemplateType.ReadOnly {
    override val smsMessage: Optional[SmsVerificationMessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smsMessage())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .SmsVerificationMessageType(value)
        )
    override val emailMessage: Optional[EmailVerificationMessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailMessage())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .EmailVerificationMessageType(value)
        )
    override val emailSubject: Optional[EmailVerificationSubjectType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailSubject())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .EmailVerificationSubjectType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.MessageTemplateType
  ): zio.aws.cognitoidentityprovider.model.MessageTemplateType.ReadOnly =
    new Wrapper(impl)
}
