package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{TagKeysType, ArnType}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: ArnType,
    tagKeys: Iterable[TagKeysType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest
      .builder()
      .resourceArn(ArnType.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKeysType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UntagResourceRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UntagResourceRequest
      .wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.UntagResourceRequest =
      zio.aws.cognitoidentityprovider.model
        .UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ArnType
    def tagKeys: List[TagKeysType]
    def getResourceArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKeysType]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest
  ) extends zio.aws.cognitoidentityprovider.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ArnType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ArnType(impl.resourceArn())
    override val tagKeys: List[TagKeysType] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.cognitoidentityprovider.model.primitives.TagKeysType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest
  ): zio.aws.cognitoidentityprovider.model.UntagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
