package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  EventIdType,
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminUpdateAuthEventFeedbackRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    eventId: EventIdType,
    feedbackValue: zio.aws.cognitoidentityprovider.model.FeedbackValueType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest = {
    import AdminUpdateAuthEventFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .eventId(EventIdType.unwrap(eventId): java.lang.String)
      .feedbackValue(feedbackValue.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest
      .wrap(buildAwsValue())
}
object AdminUpdateAuthEventFeedbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest =
      zio.aws.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest(
        userPoolId,
        username,
        eventId,
        feedbackValue
      )
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def eventId: EventIdType
    def feedbackValue: zio.aws.cognitoidentityprovider.model.FeedbackValueType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getEventId: ZIO[Any, Nothing, EventIdType] = ZIO.succeed(eventId)
    def getFeedbackValue: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.FeedbackValueType
    ] = ZIO.succeed(feedbackValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val eventId: EventIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .EventIdType(impl.eventId())
    override val feedbackValue
        : zio.aws.cognitoidentityprovider.model.FeedbackValueType =
      zio.aws.cognitoidentityprovider.model.FeedbackValueType
        .wrap(impl.feedbackValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest
  ): zio.aws.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest.ReadOnly =
    new Wrapper(impl)
}
