package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  BooleanType,
  StringType,
  ArnType,
  HexStringType
}
import scala.jdk.CollectionConverters._
final case class AnalyticsConfigurationType(
    applicationId: Optional[HexStringType] = Optional.Absent,
    applicationArn: Optional[ArnType] = Optional.Absent,
    roleArn: Optional[ArnType] = Optional.Absent,
    externalId: Optional[StringType] = Optional.Absent,
    userDataShared: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsConfigurationType = {
    import AnalyticsConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsConfigurationType
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          HexStringType.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        applicationArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.applicationArn)
      .optionallyWith(
        roleArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(externalId.map(value => value: java.lang.String))(
        _.externalId
      )
      .optionallyWith(
        userDataShared.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.userDataShared)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AnalyticsConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AnalyticsConfigurationType
      .wrap(buildAwsValue())
}
object AnalyticsConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AnalyticsConfigurationType =
      zio.aws.cognitoidentityprovider.model.AnalyticsConfigurationType(
        applicationId.map(value => value),
        applicationArn.map(value => value),
        roleArn.map(value => value),
        externalId.map(value => value),
        userDataShared.map(value => value)
      )
    def applicationId: Optional[HexStringType]
    def applicationArn: Optional[ArnType]
    def roleArn: Optional[ArnType]
    def externalId: Optional[StringType]
    def userDataShared: Optional[BooleanType]
    def getApplicationId: ZIO[Any, AwsError, HexStringType] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getApplicationArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("applicationArn", applicationArn)
    def getRoleArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getExternalId: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getUserDataShared: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("userDataShared", userDataShared)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.AnalyticsConfigurationType.ReadOnly {
    override val applicationId: Optional[HexStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.HexStringType(value)
      )
    override val applicationArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationArn())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val roleArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val externalId: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => value: StringType)
    override val userDataShared: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.userDataShared())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsConfigurationType
  ): zio.aws.cognitoidentityprovider.model.AnalyticsConfigurationType.ReadOnly =
    new Wrapper(impl)
}
