package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  UserPoolIdType,
  DomainType
}
import scala.jdk.CollectionConverters._
final case class CreateUserPoolDomainRequest(
    domain: DomainType,
    userPoolId: UserPoolIdType,
    customDomainConfig: Optional[
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest = {
    import CreateUserPoolDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest
      .builder()
      .domain(DomainType.unwrap(domain): java.lang.String)
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(customDomainConfig.map(value => value.buildAwsValue()))(
        _.customDomainConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainRequest
      .wrap(buildAwsValue())
}
object CreateUserPoolDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainRequest =
      zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainRequest(
        domain,
        userPoolId,
        customDomainConfig.map(value => value.asEditable)
      )
    def domain: DomainType
    def userPoolId: UserPoolIdType
    def customDomainConfig: Optional[
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly
    ]
    def getDomain: ZIO[Any, Nothing, DomainType] = ZIO.succeed(domain)
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getCustomDomainConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("customDomainConfig", customDomainConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest
  ) extends zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainRequest.ReadOnly {
    override val domain: DomainType =
      zio.aws.cognitoidentityprovider.model.primitives.DomainType(impl.domain())
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val customDomainConfig: Optional[
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest
  ): zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainRequest.ReadOnly =
    new Wrapper(impl)
}
