package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetUserAttributeVerificationCodeResponse(
    codeDeliveryDetails: Optional[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse = {
    import GetUserAttributeVerificationCodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse
      .builder()
      .optionallyWith(codeDeliveryDetails.map(value => value.buildAwsValue()))(
        _.codeDeliveryDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse
      .wrap(buildAwsValue())
}
object GetUserAttributeVerificationCodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse =
      zio.aws.cognitoidentityprovider.model
        .GetUserAttributeVerificationCodeResponse(
          codeDeliveryDetails.map(value => value.asEditable)
        )
    def codeDeliveryDetails: Optional[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ]
    def getCodeDeliveryDetails: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ] = AwsError.unwrapOptionField("codeDeliveryDetails", codeDeliveryDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse
  ) extends zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse.ReadOnly {
    override val codeDeliveryDetails: Optional[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.codeDeliveryDetails())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse
  ): zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse.ReadOnly =
    new Wrapper(impl)
}
