package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.PaginationKey
import scala.jdk.CollectionConverters._
final case class ListUsersInGroupResponse(
    users: Optional[Iterable[zio.aws.cognitoidentityprovider.model.UserType]] =
      Optional.Absent,
    nextToken: Optional[PaginationKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse = {
    import ListUsersInGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUsersInGroupResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUsersInGroupResponse
      .wrap(buildAwsValue())
}
object ListUsersInGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListUsersInGroupResponse =
      zio.aws.cognitoidentityprovider.model.ListUsersInGroupResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def users: Optional[
      List[zio.aws.cognitoidentityprovider.model.UserType.ReadOnly]
    ]
    def nextToken: Optional[PaginationKey]
    def getUsers: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
    ]] = AwsError.unwrapOptionField("users", users)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse
  ) extends zio.aws.cognitoidentityprovider.model.ListUsersInGroupResponse.ReadOnly {
    override val users: Optional[
      List[zio.aws.cognitoidentityprovider.model.UserType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.users())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.UserType.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationKey] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse
  ): zio.aws.cognitoidentityprovider.model.ListUsersInGroupResponse.ReadOnly =
    new Wrapper(impl)
}
