package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  UsernameType
}
import scala.jdk.CollectionConverters._
final case class GetUserResponse(
    username: UsernameType,
    userAttributes: Iterable[
      zio.aws.cognitoidentityprovider.model.AttributeType
    ],
    mfaOptions: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.MFAOptionType]
    ] = Optional.Absent,
    preferredMfaSetting: Optional[StringType] = Optional.Absent,
    userMFASettingList: Optional[Iterable[StringType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse = {
    import GetUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse
      .builder()
      .username(UsernameType.unwrap(username): java.lang.String)
      .userAttributes(userAttributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        mfaOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mfaOptions)
      .optionallyWith(
        preferredMfaSetting.map(value => value: java.lang.String)
      )(_.preferredMfaSetting)
      .optionallyWith(
        userMFASettingList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userMFASettingList)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetUserResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetUserResponse.wrap(buildAwsValue())
}
object GetUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.GetUserResponse =
      zio.aws.cognitoidentityprovider.model.GetUserResponse(
        username,
        userAttributes.map { item =>
          item.asEditable
        },
        mfaOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        preferredMfaSetting.map(value => value),
        userMFASettingList.map(value => value)
      )
    def username: UsernameType
    def userAttributes
        : List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    def mfaOptions: Optional[
      List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly]
    ]
    def preferredMfaSetting: Optional[StringType]
    def userMFASettingList: Optional[List[StringType]]
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getUserAttributes: ZIO[Any, Nothing, List[
      zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly
    ]] = ZIO.succeed(userAttributes)
    def getMfaOptions: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly
    ]] = AwsError.unwrapOptionField("mfaOptions", mfaOptions)
    def getPreferredMfaSetting: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("preferredMfaSetting", preferredMfaSetting)
    def getUserMFASettingList: ZIO[Any, AwsError, List[StringType]] =
      AwsError.unwrapOptionField("userMFASettingList", userMFASettingList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse
  ) extends zio.aws.cognitoidentityprovider.model.GetUserResponse.ReadOnly {
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val userAttributes
        : List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly] =
      impl
        .userAttributes()
        .asScala
        .map { item =>
          zio.aws.cognitoidentityprovider.model.AttributeType.wrap(item)
        }
        .toList
    override val mfaOptions: Optional[
      List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mfaOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.MFAOptionType.wrap(item)
        }.toList
      )
    override val preferredMfaSetting: Optional[StringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMfaSetting())
        .map(value => value: StringType)
    override val userMFASettingList: Optional[List[StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userMFASettingList())
        .map(value =>
          value.asScala.map { item =>
            item: StringType
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse
  ): zio.aws.cognitoidentityprovider.model.GetUserResponse.ReadOnly =
    new Wrapper(impl)
}
