package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  DomainVersionType,
  UserPoolIdType,
  S3BucketType,
  AWSAccountIdType,
  StringType,
  DomainType
}
import scala.jdk.CollectionConverters._
final case class DomainDescriptionType(
    userPoolId: Optional[UserPoolIdType] = Optional.Absent,
    awsAccountId: Optional[AWSAccountIdType] = Optional.Absent,
    domain: Optional[DomainType] = Optional.Absent,
    s3Bucket: Optional[S3BucketType] = Optional.Absent,
    cloudFrontDistribution: Optional[StringType] = Optional.Absent,
    version: Optional[DomainVersionType] = Optional.Absent,
    status: Optional[zio.aws.cognitoidentityprovider.model.DomainStatusType] =
      Optional.Absent,
    customDomainConfig: Optional[
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DomainDescriptionType = {
    import DomainDescriptionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DomainDescriptionType
      .builder()
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        awsAccountId.map(value =>
          AWSAccountIdType.unwrap(value): java.lang.String
        )
      )(_.awsAccountId)
      .optionallyWith(
        domain.map(value => DomainType.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        s3Bucket.map(value => S3BucketType.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        cloudFrontDistribution.map(value => value: java.lang.String)
      )(_.cloudFrontDistribution)
      .optionallyWith(
        version.map(value => DomainVersionType.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(customDomainConfig.map(value => value.buildAwsValue()))(
        _.customDomainConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DomainDescriptionType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DomainDescriptionType
      .wrap(buildAwsValue())
}
object DomainDescriptionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DomainDescriptionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DomainDescriptionType =
      zio.aws.cognitoidentityprovider.model.DomainDescriptionType(
        userPoolId.map(value => value),
        awsAccountId.map(value => value),
        domain.map(value => value),
        s3Bucket.map(value => value),
        cloudFrontDistribution.map(value => value),
        version.map(value => value),
        status.map(value => value),
        customDomainConfig.map(value => value.asEditable)
      )
    def userPoolId: Optional[UserPoolIdType]
    def awsAccountId: Optional[AWSAccountIdType]
    def domain: Optional[DomainType]
    def s3Bucket: Optional[S3BucketType]
    def cloudFrontDistribution: Optional[StringType]
    def version: Optional[DomainVersionType]
    def status: Optional[zio.aws.cognitoidentityprovider.model.DomainStatusType]
    def customDomainConfig: Optional[
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly
    ]
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getAwsAccountId: ZIO[Any, AwsError, AWSAccountIdType] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getDomain: ZIO[Any, AwsError, DomainType] =
      AwsError.unwrapOptionField("domain", domain)
    def getS3Bucket: ZIO[Any, AwsError, S3BucketType] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getCloudFrontDistribution: ZIO[Any, AwsError, StringType] = AwsError
      .unwrapOptionField("cloudFrontDistribution", cloudFrontDistribution)
    def getVersion: ZIO[Any, AwsError, DomainVersionType] =
      AwsError.unwrapOptionField("version", version)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DomainStatusType
    ] = AwsError.unwrapOptionField("status", status)
    def getCustomDomainConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("customDomainConfig", customDomainConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DomainDescriptionType
  ) extends zio.aws.cognitoidentityprovider.model.DomainDescriptionType.ReadOnly {
    override val userPoolId: Optional[UserPoolIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val awsAccountId: Optional[AWSAccountIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsAccountId())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .AWSAccountIdType(value)
        )
    override val domain: Optional[DomainType] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DomainType(value)
      )
    override val s3Bucket: Optional[S3BucketType] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.S3BucketType(value)
      )
    override val cloudFrontDistribution: Optional[StringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudFrontDistribution())
        .map(value => value: StringType)
    override val version: Optional[DomainVersionType] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .DomainVersionType(value)
      )
    override val status
        : Optional[zio.aws.cognitoidentityprovider.model.DomainStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.DomainStatusType.wrap(value)
        )
    override val customDomainConfig: Optional[
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DomainDescriptionType
  ): zio.aws.cognitoidentityprovider.model.DomainDescriptionType.ReadOnly =
    new Wrapper(impl)
}
