package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait DeviceRememberedStatusType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType
}
object DeviceRememberedStatusType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType
  ): zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType.REMEMBERED =>
        val r = remembered
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType.NOT_REMEMBERED =>
        val r = not_remembered
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object remembered
      extends zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType.REMEMBERED
  }
  case object not_remembered
      extends zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType.NOT_REMEMBERED
  }
}
