package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  DateType,
  UserPoolNameType,
  UserPoolIdType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UserPoolDescriptionType(
    id: Optional[UserPoolIdType] = Optional.Absent,
    name: Optional[UserPoolNameType] = Optional.Absent,
    lambdaConfig: Optional[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType
    ] = Optional.Absent,
    status: Optional[zio.aws.cognitoidentityprovider.model.StatusType] =
      Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType = {
    import UserPoolDescriptionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType
      .builder()
      .optionallyWith(
        id.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => UserPoolNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(lambdaConfig.map(value => value.buildAwsValue()))(
        _.lambdaConfig
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType
      .wrap(buildAwsValue())
}
object UserPoolDescriptionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType =
      zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType(
        id.map(value => value),
        name.map(value => value),
        lambdaConfig.map(value => value.asEditable),
        status.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value)
      )
    def id: Optional[UserPoolIdType]
    def name: Optional[UserPoolNameType]
    def lambdaConfig: Optional[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ]
    def status: Optional[zio.aws.cognitoidentityprovider.model.StatusType]
    def lastModifiedDate: Optional[DateType]
    def creationDate: Optional[DateType]
    def getId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, UserPoolNameType] =
      AwsError.unwrapOptionField("name", name)
    def getLambdaConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaConfig", lambdaConfig)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cognitoidentityprovider.model.StatusType] =
      AwsError.unwrapOptionField("status", status)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType
  ) extends zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly {
    override val id: Optional[UserPoolIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val name: Optional[UserPoolNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolNameType(value)
      )
    override val lambdaConfig: Optional[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.LambdaConfigType.wrap(value)
      )
    override val status
        : Optional[zio.aws.cognitoidentityprovider.model.StatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.StatusType.wrap(value)
        )
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType
  ): zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly =
    new Wrapper(impl)
}
