package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class AnalyticsMetadataType(
    analyticsEndpointId: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsMetadataType = {
    import AnalyticsMetadataType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsMetadataType
      .builder()
      .optionallyWith(
        analyticsEndpointId.map(value => value: java.lang.String)
      )(_.analyticsEndpointId)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType
      .wrap(buildAwsValue())
}
object AnalyticsMetadataType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsMetadataType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType =
      zio.aws.cognitoidentityprovider.model
        .AnalyticsMetadataType(analyticsEndpointId.map(value => value))
    def analyticsEndpointId: Optional[StringType]
    def getAnalyticsEndpointId: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("analyticsEndpointId", analyticsEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsMetadataType
  ) extends zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly {
    override val analyticsEndpointId: Optional[StringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analyticsEndpointId())
        .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsMetadataType
  ): zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly =
    new Wrapper(impl)
}
