package zio.aws.cognitoidentityprovider
import zio.aws.cognitoidentityprovider.model.AdminDisableProviderForUserResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersPublisher
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.cognitoidentityprovider.model.{
  CreateResourceServerRequest,
  GetCsvHeaderRequest,
  DeleteUserRequest,
  SignUpRequest,
  AssociateSoftwareTokenRequest,
  CreateUserPoolDomainRequest,
  ForgetDeviceRequest,
  DeleteUserPoolRequest,
  SetUserMfaPreferenceRequest,
  ChangePasswordRequest,
  AdminDeleteUserAttributesRequest,
  AdminSetUserMfaPreferenceRequest,
  InitiateAuthRequest,
  AdminSetUserPasswordRequest,
  UpdateUserPoolRequest,
  AddCustomAttributesRequest,
  RespondToAuthChallengeRequest,
  GetUserAttributeVerificationCodeRequest,
  ListResourceServersRequest,
  UpdateUserAttributesRequest,
  ResendConfirmationCodeRequest,
  ConfirmSignUpRequest,
  ConfirmDeviceRequest,
  AdminDisableProviderForUserRequest,
  GetIdentityProviderByIdentifierRequest,
  GetGroupRequest,
  DescribeIdentityProviderRequest,
  ListUsersRequest,
  ListUserPoolClientsRequest,
  GetUserPoolMfaConfigRequest,
  AdminUserGlobalSignOutRequest,
  AdminForgetDeviceRequest,
  UpdateGroupRequest,
  StopUserImportJobRequest,
  ListUserImportJobsRequest,
  SetUserSettingsRequest,
  AdminUpdateAuthEventFeedbackRequest,
  ListIdentityProvidersRequest,
  CreateIdentityProviderRequest,
  SetUiCustomizationRequest,
  CreateUserPoolRequest,
  AdminLinkProviderForUserRequest,
  GetDeviceRequest,
  ConfirmForgotPasswordRequest,
  AdminInitiateAuthRequest,
  DescribeUserPoolRequest,
  ListTagsForResourceRequest,
  SetUserPoolMfaConfigRequest,
  AdminListGroupsForUserRequest,
  DescribeUserPoolClientRequest,
  AdminDisableUserRequest,
  DeleteGroupRequest,
  AdminGetDeviceRequest,
  AdminConfirmSignUpRequest,
  CreateUserImportJobRequest,
  ListGroupsRequest,
  GetUiCustomizationRequest,
  UpdateDeviceStatusRequest,
  GlobalSignOutRequest,
  StartUserImportJobRequest,
  UpdateUserPoolDomainRequest,
  AdminEnableUserRequest,
  VerifyUserAttributeRequest,
  AdminGetUserRequest,
  AdminListDevicesRequest,
  DescribeUserImportJobRequest,
  UpdateIdentityProviderRequest,
  DeleteUserPoolClientRequest,
  GetUserRequest,
  DeleteResourceServerRequest,
  AdminListUserAuthEventsRequest,
  DeleteUserPoolDomainRequest,
  ListUserPoolsRequest,
  CreateUserPoolClientRequest,
  UntagResourceRequest,
  AdminAddUserToGroupRequest,
  SetRiskConfigurationRequest,
  ListUsersInGroupRequest,
  DescribeUserPoolDomainRequest,
  ForgotPasswordRequest,
  AdminRespondToAuthChallengeRequest,
  CreateGroupRequest,
  AdminResetUserPasswordRequest,
  AdminRemoveUserFromGroupRequest,
  ListDevicesRequest,
  RevokeTokenRequest,
  VerifySoftwareTokenRequest,
  AdminUpdateDeviceStatusRequest,
  AdminCreateUserRequest,
  DescribeRiskConfigurationRequest,
  GetSigningCertificateRequest,
  DeleteUserAttributesRequest,
  UpdateUserPoolClientRequest,
  UpdateResourceServerRequest,
  AdminDeleteUserRequest,
  TagResourceRequest,
  DescribeResourceServerRequest,
  AdminUpdateUserAttributesRequest,
  DeleteIdentityProviderRequest,
  AdminSetUserSettingsRequest,
  UpdateAuthEventFeedbackRequest
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.cognitoidentityprovider.{
  CognitoIdentityProviderAsyncClientBuilder,
  CognitoIdentityProviderAsyncClient
}
import zio.stream.ZStream
import software.amazon.awssdk.services.cognitoidentityprovider.model.{
  DeleteGroupResponse,
  ListUserImportJobsResponse,
  UserType,
  AdminUpdateUserAttributesResponse,
  AdminRemoveUserFromGroupResponse,
  AdminInitiateAuthResponse,
  DescribeIdentityProviderResponse,
  SetUiCustomizationResponse,
  AdminGetDeviceResponse,
  StopUserImportJobResponse,
  GetUiCustomizationResponse,
  DeleteUserPoolClientResponse,
  ResendConfirmationCodeResponse,
  AdminAddUserToGroupResponse,
  AssociateSoftwareTokenResponse,
  AdminListUserAuthEventsResponse,
  VerifyUserAttributeResponse,
  GetSigningCertificateResponse,
  AdminForgetDeviceResponse,
  CreateResourceServerResponse,
  AdminListGroupsForUserResponse,
  ListUsersInGroupResponse,
  UpdateResourceServerResponse,
  ListUsersResponse,
  ListIdentityProvidersResponse,
  DeleteUserAttributesResponse,
  AdminGetUserResponse,
  UpdateAuthEventFeedbackResponse,
  AdminRespondToAuthChallengeResponse,
  ListUserPoolClientsResponse,
  DescribeRiskConfigurationResponse,
  ForgetDeviceResponse,
  AddCustomAttributesResponse,
  AdminUserGlobalSignOutResponse,
  AdminResetUserPasswordResponse,
  DescribeUserPoolClientResponse,
  UserPoolClientDescription,
  AdminEnableUserResponse,
  UpdateIdentityProviderResponse,
  ListDevicesResponse,
  UpdateDeviceStatusResponse,
  CreateUserImportJobResponse,
  AdminListDevicesResponse,
  GetUserResponse,
  SetRiskConfigurationResponse,
  ListUserPoolsResponse,
  ConfirmDeviceResponse,
  AdminDeleteUserAttributesResponse,
  CreateUserPoolResponse,
  AdminUpdateAuthEventFeedbackResponse,
  AdminConfirmSignUpResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  SetUserSettingsResponse,
  AdminLinkProviderForUserResponse,
  DescribeUserPoolResponse,
  AdminSetUserPasswordResponse,
  DescribeUserImportJobResponse,
  GetDeviceResponse,
  UpdateUserPoolClientResponse,
  UpdateUserPoolResponse,
  DescribeResourceServerResponse,
  UserPoolDescriptionType,
  AdminSetUserSettingsResponse,
  UpdateUserAttributesResponse,
  ListResourceServersResponse,
  ConfirmForgotPasswordResponse,
  ResourceServerType,
  ListGroupsResponse,
  GetIdentityProviderByIdentifierResponse,
  DeleteResourceServerResponse,
  GetCsvHeaderResponse,
  AdminDeleteUserResponse,
  UpdateUserPoolDomainResponse,
  GlobalSignOutResponse,
  SignUpResponse,
  RevokeTokenResponse,
  RespondToAuthChallengeResponse,
  CreateIdentityProviderResponse,
  ProviderDescription,
  CreateGroupResponse,
  ChangePasswordResponse,
  GetUserAttributeVerificationCodeResponse,
  DeleteUserResponse,
  StartUserImportJobResponse,
  AdminSetUserMfaPreferenceResponse,
  AdminDisableProviderForUserResponse,
  AdminCreateUserResponse,
  AdminUpdateDeviceStatusResponse,
  DeleteUserPoolResponse,
  SetUserMfaPreferenceResponse,
  AdminDisableUserResponse,
  AuthEventType,
  ConfirmSignUpResponse,
  CreateUserPoolClientResponse,
  SetUserPoolMfaConfigResponse,
  TagResourceResponse,
  DeleteUserPoolDomainResponse,
  DescribeUserPoolDomainResponse,
  DeleteIdentityProviderResponse,
  GroupType,
  GetGroupResponse,
  CreateUserPoolDomainResponse,
  GetUserPoolMfaConfigResponse,
  ForgotPasswordResponse,
  UpdateGroupResponse,
  InitiateAuthResponse,
  VerifySoftwareTokenResponse
}
import scala.jdk.CollectionConverters._
trait CognitoIdentityProvider extends AspectSupport[CognitoIdentityProvider] {
  val api: CognitoIdentityProviderAsyncClient
  def adminConfirmSignUp(request: AdminConfirmSignUpRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminConfirmSignUpResponse.ReadOnly
  ]
  def createIdentityProvider(request: CreateIdentityProviderRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateIdentityProviderResponse.ReadOnly
  ]
  def adminEnableUser(request: AdminEnableUserRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminEnableUserResponse.ReadOnly
  ]
  def revokeToken(request: RevokeTokenRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.RevokeTokenResponse.ReadOnly
  ]
  def stopUserImportJob(request: StopUserImportJobRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.StopUserImportJobResponse.ReadOnly
  ]
  def adminRemoveUserFromGroup(
      request: AdminRemoveUserFromGroupRequest
  ): IO[AwsError, Unit]
  def describeUserPoolDomain(request: DescribeUserPoolDomainRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainResponse.ReadOnly
  ]
  def listUsers(request: ListUsersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
  ]
  def listUsersPaginated(request: ListUsersRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListUsersResponse.ReadOnly
  ]
  def listUsersInGroup(request: ListUsersInGroupRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
  ]
  def listUsersInGroupPaginated(request: ListUsersInGroupRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListUsersInGroupResponse.ReadOnly
  ]
  def globalSignOut(request: GlobalSignOutRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.GlobalSignOutResponse.ReadOnly
  ]
  def adminGetUser(request: AdminGetUserRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminGetUserResponse.ReadOnly
  ]
  def createUserPoolDomain(request: CreateUserPoolDomainRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainResponse.ReadOnly
  ]
  def associateSoftwareToken(request: AssociateSoftwareTokenRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse.ReadOnly
  ]
  def adminUpdateAuthEventFeedback(
      request: AdminUpdateAuthEventFeedbackRequest
  ): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse.ReadOnly
  ]
  def describeUserPool(request: DescribeUserPoolRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeUserPoolResponse.ReadOnly
  ]
  def describeIdentityProvider(request: DescribeIdentityProviderRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeIdentityProviderResponse.ReadOnly
  ]
  def adminUpdateDeviceStatus(request: AdminUpdateDeviceStatusRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse.ReadOnly
  ]
  def adminUpdateUserAttributes(request: AdminUpdateUserAttributesRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse.ReadOnly
  ]
  def resendConfirmationCode(request: ResendConfirmationCodeRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeResponse.ReadOnly
  ]
  def signUp(
      request: SignUpRequest
  ): IO[AwsError, zio.aws.cognitoidentityprovider.model.SignUpResponse.ReadOnly]
  def deleteIdentityProvider(
      request: DeleteIdentityProviderRequest
  ): IO[AwsError, Unit]
  def getUserAttributeVerificationCode(
      request: GetUserAttributeVerificationCodeRequest
  ): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse.ReadOnly
  ]
  def deleteUserPoolClient(
      request: DeleteUserPoolClientRequest
  ): IO[AwsError, Unit]
  def deleteGroup(request: DeleteGroupRequest): IO[AwsError, Unit]
  def adminSetUserSettings(request: AdminSetUserSettingsRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminSetUserSettingsResponse.ReadOnly
  ]
  def getSigningCertificate(request: GetSigningCertificateRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse.ReadOnly
  ]
  def getUserPoolMfaConfig(request: GetUserPoolMfaConfigRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse.ReadOnly
  ]
  def updateUserPoolClient(request: UpdateUserPoolClientRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateUserPoolClientResponse.ReadOnly
  ]
  def initiateAuth(request: InitiateAuthRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.InitiateAuthResponse.ReadOnly
  ]
  def changePassword(request: ChangePasswordRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ChangePasswordResponse.ReadOnly
  ]
  def adminListGroupsForUser(request: AdminListGroupsForUserRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
  ]
  def adminListGroupsForUserPaginated(
      request: AdminListGroupsForUserRequest
  ): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserResponse.ReadOnly
  ]
  def deleteUserAttributes(request: DeleteUserAttributesRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.DeleteUserAttributesResponse.ReadOnly
  ]
  def adminResetUserPassword(request: AdminResetUserPasswordRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminResetUserPasswordResponse.ReadOnly
  ]
  def addCustomAttributes(request: AddCustomAttributesRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AddCustomAttributesResponse.ReadOnly
  ]
  def adminUserGlobalSignOut(request: AdminUserGlobalSignOutRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse.ReadOnly
  ]
  def getUICustomization(request: GetUiCustomizationRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetUiCustomizationResponse.ReadOnly
  ]
  def createResourceServer(request: CreateResourceServerRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateResourceServerResponse.ReadOnly
  ]
  def adminDisableUser(request: AdminDisableUserRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminDisableUserResponse.ReadOnly
  ]
  def respondToAuthChallenge(request: RespondToAuthChallengeRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeResponse.ReadOnly
  ]
  def getUser(request: GetUserRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetUserResponse.ReadOnly
  ]
  def deleteResourceServer(
      request: DeleteResourceServerRequest
  ): IO[AwsError, Unit]
  def listGroups(request: ListGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
  ]
  def listGroupsPaginated(request: ListGroupsRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListGroupsResponse.ReadOnly
  ]
  def listDevices(request: ListDevicesRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListDevicesResponse.ReadOnly
  ]
  def verifySoftwareToken(request: VerifySoftwareTokenRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponse.ReadOnly
  ]
  def adminDisableProviderForUser(
      request: AdminDisableProviderForUserRequest
  ): IO[AwsError, ReadOnly]
  def forgotPassword(request: ForgotPasswordRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ForgotPasswordResponse.ReadOnly
  ]
  def updateAuthEventFeedback(request: UpdateAuthEventFeedbackRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse.ReadOnly
  ]
  def updateIdentityProvider(request: UpdateIdentityProviderRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateIdentityProviderResponse.ReadOnly
  ]
  def listUserPoolClients(request: ListUserPoolClientsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UserPoolClientDescription.ReadOnly
  ]
  def listUserPoolClientsPaginated(request: ListUserPoolClientsRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListUserPoolClientsResponse.ReadOnly
  ]
  def startUserImportJob(request: StartUserImportJobRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.StartUserImportJobResponse.ReadOnly
  ]
  def updateUserAttributes(request: UpdateUserAttributesRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateUserAttributesResponse.ReadOnly
  ]
  def adminListUserAuthEvents(request: AdminListUserAuthEventsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly
  ]
  def adminListUserAuthEventsPaginated(
      request: AdminListUserAuthEventsRequest
  ): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse.ReadOnly
  ]
  def listIdentityProviders(request: ListIdentityProvidersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ProviderDescription.ReadOnly
  ]
  def listIdentityProvidersPaginated(request: ListIdentityProvidersRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListIdentityProvidersResponse.ReadOnly
  ]
  def listUserImportJobs(request: ListUserImportJobsRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListUserImportJobsResponse.ReadOnly
  ]
  def adminCreateUser(request: AdminCreateUserRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminCreateUserResponse.ReadOnly
  ]
  def adminInitiateAuth(request: AdminInitiateAuthRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminInitiateAuthResponse.ReadOnly
  ]
  def confirmSignUp(request: ConfirmSignUpRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ConfirmSignUpResponse.ReadOnly
  ]
  def adminGetDevice(request: AdminGetDeviceRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminGetDeviceResponse.ReadOnly
  ]
  def adminLinkProviderForUser(request: AdminLinkProviderForUserRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminLinkProviderForUserResponse.ReadOnly
  ]
  def confirmForgotPassword(request: ConfirmForgotPasswordRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ConfirmForgotPasswordResponse.ReadOnly
  ]
  def setRiskConfiguration(request: SetRiskConfigurationRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.SetRiskConfigurationResponse.ReadOnly
  ]
  def forgetDevice(request: ForgetDeviceRequest): IO[AwsError, Unit]
  def deleteUserPool(request: DeleteUserPoolRequest): IO[AwsError, Unit]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.UntagResourceResponse.ReadOnly
  ]
  def listResourceServers(request: ListResourceServersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly
  ]
  def listResourceServersPaginated(request: ListResourceServersRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListResourceServersResponse.ReadOnly
  ]
  def describeUserImportJob(request: DescribeUserImportJobRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeUserImportJobResponse.ReadOnly
  ]
  def deleteUserPoolDomain(request: DeleteUserPoolDomainRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.DeleteUserPoolDomainResponse.ReadOnly
  ]
  def setUserSettings(request: SetUserSettingsRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.SetUserSettingsResponse.ReadOnly
  ]
  def adminDeleteUser(request: AdminDeleteUserRequest): IO[AwsError, Unit]
  def adminRespondToAuthChallenge(
      request: AdminRespondToAuthChallengeRequest
  ): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse.ReadOnly
  ]
  def createGroup(request: CreateGroupRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateGroupResponse.ReadOnly
  ]
  def adminAddUserToGroup(
      request: AdminAddUserToGroupRequest
  ): IO[AwsError, Unit]
  def adminSetUserPassword(request: AdminSetUserPasswordRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminSetUserPasswordResponse.ReadOnly
  ]
  def setUserMFAPreference(request: SetUserMfaPreferenceRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.SetUserMfaPreferenceResponse.ReadOnly
  ]
  def updateUserPoolDomain(request: UpdateUserPoolDomainRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainResponse.ReadOnly
  ]
  def setUICustomization(request: SetUiCustomizationRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.SetUiCustomizationResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListTagsForResourceResponse.ReadOnly
  ]
  def updateGroup(request: UpdateGroupRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateGroupResponse.ReadOnly
  ]
  def confirmDevice(request: ConfirmDeviceRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.TagResourceResponse.ReadOnly
  ]
  def adminDeleteUserAttributes(request: AdminDeleteUserAttributesRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse.ReadOnly
  ]
  def adminForgetDevice(request: AdminForgetDeviceRequest): IO[AwsError, Unit]
  def createUserPool(request: CreateUserPoolRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateUserPoolResponse.ReadOnly
  ]
  def deleteUser(request: DeleteUserRequest): IO[AwsError, Unit]
  def createUserImportJob(request: CreateUserImportJobRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateUserImportJobResponse.ReadOnly
  ]
  def getGroup(request: GetGroupRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetGroupResponse.ReadOnly
  ]
  def createUserPoolClient(request: CreateUserPoolClientRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateUserPoolClientResponse.ReadOnly
  ]
  def updateUserPool(request: UpdateUserPoolRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateUserPoolResponse.ReadOnly
  ]
  def updateDeviceStatus(request: UpdateDeviceStatusRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateDeviceStatusResponse.ReadOnly
  ]
  def describeUserPoolClient(request: DescribeUserPoolClientRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientResponse.ReadOnly
  ]
  def getCSVHeader(request: GetCsvHeaderRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetCsvHeaderResponse.ReadOnly
  ]
  def describeResourceServer(request: DescribeResourceServerRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeResourceServerResponse.ReadOnly
  ]
  def setUserPoolMfaConfig(request: SetUserPoolMfaConfigRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse.ReadOnly
  ]
  def describeRiskConfiguration(request: DescribeRiskConfigurationRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationResponse.ReadOnly
  ]
  def listUserPools(request: ListUserPoolsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly
  ]
  def listUserPoolsPaginated(request: ListUserPoolsRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse.ReadOnly
  ]
  def adminListDevices(request: AdminListDevicesRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminListDevicesResponse.ReadOnly
  ]
  def getDevice(request: GetDeviceRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetDeviceResponse.ReadOnly
  ]
  def adminSetUserMFAPreference(request: AdminSetUserMfaPreferenceRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse.ReadOnly
  ]
  def updateResourceServer(request: UpdateResourceServerRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateResourceServerResponse.ReadOnly
  ]
  def verifyUserAttribute(request: VerifyUserAttributeRequest): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.VerifyUserAttributeResponse.ReadOnly
  ]
  def getIdentityProviderByIdentifier(
      request: GetIdentityProviderByIdentifierRequest
  ): IO[
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse.ReadOnly
  ]
}
object CognitoIdentityProvider {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CognitoIdentityProvider] =
    customized(identity)
  def customized(
      customization: CognitoIdentityProviderAsyncClientBuilder => CognitoIdentityProviderAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CognitoIdentityProvider] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: CognitoIdentityProviderAsyncClientBuilder => CognitoIdentityProviderAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, CognitoIdentityProvider] =
    for (
      awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
      builder = CognitoIdentityProviderAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig.configure[
        CognitoIdentityProviderAsyncClient,
        CognitoIdentityProviderAsyncClientBuilder
      ](builder);
      b1 <- awsConfig.configureHttpClient[
        CognitoIdentityProviderAsyncClient,
        CognitoIdentityProviderAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
    )
      yield new CognitoIdentityProviderImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class CognitoIdentityProviderImpl[R](
      override val api: CognitoIdentityProviderAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CognitoIdentityProvider
      with AwsServiceBase[R] {
    override val serviceName: String = "CognitoIdentityProvider"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CognitoIdentityProviderImpl[R1] =
      new CognitoIdentityProviderImpl(api, newAspect, r)
    def adminConfirmSignUp(request: AdminConfirmSignUpRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminConfirmSignUpResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest,
      AdminConfirmSignUpResponse
    ]("adminConfirmSignUp", api.adminConfirmSignUp)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.AdminConfirmSignUpResponse.wrap
      )
      .provideEnvironment(r)
    def createIdentityProvider(request: CreateIdentityProviderRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.CreateIdentityProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest,
      CreateIdentityProviderResponse
    ]("createIdentityProvider", api.createIdentityProvider)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.CreateIdentityProviderResponse.wrap
    ).provideEnvironment(r)
    def adminEnableUser(request: AdminEnableUserRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminEnableUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest,
      AdminEnableUserResponse
    ]("adminEnableUser", api.adminEnableUser)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.AdminEnableUserResponse.wrap)
      .provideEnvironment(r)
    def revokeToken(request: RevokeTokenRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.RevokeTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest,
      RevokeTokenResponse
    ]("revokeToken", api.revokeToken)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.RevokeTokenResponse.wrap)
      .provideEnvironment(r)
    def stopUserImportJob(request: StopUserImportJobRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.StopUserImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest,
      StopUserImportJobResponse
    ]("stopUserImportJob", api.stopUserImportJob)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.StopUserImportJobResponse.wrap)
      .provideEnvironment(r)
    def adminRemoveUserFromGroup(
        request: AdminRemoveUserFromGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest,
      AdminRemoveUserFromGroupResponse
    ]("adminRemoveUserFromGroup", api.adminRemoveUserFromGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeUserPoolDomain(request: DescribeUserPoolDomainRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest,
      DescribeUserPoolDomainResponse
    ]("describeUserPoolDomain", api.describeUserPoolDomain)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainResponse.wrap
    ).provideEnvironment(r)
    def listUsers(request: ListUsersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest,
      UserType,
      ListUsersPublisher
    ]("listUsers", api.listUsersPaginator, _.users())(request.buildAwsValue())
      .map(item => zio.aws.cognitoidentityprovider.model.UserType.wrap(item))
      .provideEnvironment(r)
    def listUsersPaginated(request: ListUsersRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ListUsersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest,
      ListUsersResponse
    ]("listUsers", api.listUsers)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.ListUsersResponse.wrap)
      .provideEnvironment(r)
    def listUsersInGroup(request: ListUsersInGroupRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest,
      ListUsersInGroupResponse,
      UserType
    ](
      "listUsersInGroup",
      api.listUsersInGroup,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.users().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cognitoidentityprovider.model.UserType.wrap(item))
      .provideEnvironment(r)
    def listUsersInGroupPaginated(request: ListUsersInGroupRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ListUsersInGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest,
      ListUsersInGroupResponse
    ]("listUsersInGroup", api.listUsersInGroup)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.ListUsersInGroupResponse.wrap)
      .provideEnvironment(r)
    def globalSignOut(request: GlobalSignOutRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.GlobalSignOutResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest,
      GlobalSignOutResponse
    ]("globalSignOut", api.globalSignOut)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.GlobalSignOutResponse.wrap)
      .provideEnvironment(r)
    def adminGetUser(request: AdminGetUserRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminGetUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserRequest,
      AdminGetUserResponse
    ]("adminGetUser", api.adminGetUser)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.AdminGetUserResponse.wrap)
      .provideEnvironment(r)
    def createUserPoolDomain(request: CreateUserPoolDomainRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest,
      CreateUserPoolDomainResponse
    ]("createUserPoolDomain", api.createUserPoolDomain)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainResponse.wrap
      )
      .provideEnvironment(r)
    def associateSoftwareToken(request: AssociateSoftwareTokenRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest,
      AssociateSoftwareTokenResponse
    ]("associateSoftwareToken", api.associateSoftwareToken)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse.wrap
    ).provideEnvironment(r)
    def adminUpdateAuthEventFeedback(
        request: AdminUpdateAuthEventFeedbackRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest,
      AdminUpdateAuthEventFeedbackResponse
    ]("adminUpdateAuthEventFeedback", api.adminUpdateAuthEventFeedback)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse.wrap
    ).provideEnvironment(r)
    def describeUserPool(request: DescribeUserPoolRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.DescribeUserPoolResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest,
      DescribeUserPoolResponse
    ]("describeUserPool", api.describeUserPool)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.DescribeUserPoolResponse.wrap)
      .provideEnvironment(r)
    def describeIdentityProvider(request: DescribeIdentityProviderRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.DescribeIdentityProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderRequest,
      DescribeIdentityProviderResponse
    ]("describeIdentityProvider", api.describeIdentityProvider)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.DescribeIdentityProviderResponse.wrap
    ).provideEnvironment(r)
    def adminUpdateDeviceStatus(request: AdminUpdateDeviceStatusRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest,
      AdminUpdateDeviceStatusResponse
    ]("adminUpdateDeviceStatus", api.adminUpdateDeviceStatus)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse.wrap
    ).provideEnvironment(r)
    def adminUpdateUserAttributes(
        request: AdminUpdateUserAttributesRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest,
      AdminUpdateUserAttributesResponse
    ]("adminUpdateUserAttributes", api.adminUpdateUserAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse.wrap
    ).provideEnvironment(r)
    def resendConfirmationCode(request: ResendConfirmationCodeRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest,
      ResendConfirmationCodeResponse
    ]("resendConfirmationCode", api.resendConfirmationCode)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeResponse.wrap
    ).provideEnvironment(r)
    def signUp(request: SignUpRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.SignUpResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest,
      SignUpResponse
    ]("signUp", api.signUp)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.SignUpResponse.wrap)
      .provideEnvironment(r)
    def deleteIdentityProvider(
        request: DeleteIdentityProviderRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest,
      DeleteIdentityProviderResponse
    ]("deleteIdentityProvider", api.deleteIdentityProvider)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getUserAttributeVerificationCode(
        request: GetUserAttributeVerificationCodeRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest,
      GetUserAttributeVerificationCodeResponse
    ]("getUserAttributeVerificationCode", api.getUserAttributeVerificationCode)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse.wrap
    ).provideEnvironment(r)
    def deleteUserPoolClient(
        request: DeleteUserPoolClientRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientRequest,
      DeleteUserPoolClientResponse
    ]("deleteUserPoolClient", api.deleteUserPoolClient)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteGroup(request: DeleteGroupRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest,
        DeleteGroupResponse
      ]("deleteGroup", api.deleteGroup)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def adminSetUserSettings(request: AdminSetUserSettingsRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminSetUserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest,
      AdminSetUserSettingsResponse
    ]("adminSetUserSettings", api.adminSetUserSettings)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.AdminSetUserSettingsResponse.wrap
      )
      .provideEnvironment(r)
    def getSigningCertificate(request: GetSigningCertificateRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest,
      GetSigningCertificateResponse
    ]("getSigningCertificate", api.getSigningCertificate)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse.wrap
    ).provideEnvironment(r)
    def getUserPoolMfaConfig(request: GetUserPoolMfaConfigRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest,
      GetUserPoolMfaConfigResponse
    ]("getUserPoolMfaConfig", api.getUserPoolMfaConfig)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse.wrap
      )
      .provideEnvironment(r)
    def updateUserPoolClient(request: UpdateUserPoolClientRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.UpdateUserPoolClientResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest,
      UpdateUserPoolClientResponse
    ]("updateUserPoolClient", api.updateUserPoolClient)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.UpdateUserPoolClientResponse.wrap
      )
      .provideEnvironment(r)
    def initiateAuth(request: InitiateAuthRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.InitiateAuthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest,
      InitiateAuthResponse
    ]("initiateAuth", api.initiateAuth)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.InitiateAuthResponse.wrap)
      .provideEnvironment(r)
    def changePassword(request: ChangePasswordRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ChangePasswordResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest,
      ChangePasswordResponse
    ]("changePassword", api.changePassword)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.ChangePasswordResponse.wrap)
      .provideEnvironment(r)
    def adminListGroupsForUser(request: AdminListGroupsForUserRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest,
      AdminListGroupsForUserResponse,
      GroupType
    ](
      "adminListGroupsForUser",
      api.adminListGroupsForUser,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.groups().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cognitoidentityprovider.model.GroupType.wrap(item))
      .provideEnvironment(r)
    def adminListGroupsForUserPaginated(
        request: AdminListGroupsForUserRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest,
      AdminListGroupsForUserResponse
    ]("adminListGroupsForUser", api.adminListGroupsForUser)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserResponse.wrap
    ).provideEnvironment(r)
    def deleteUserAttributes(request: DeleteUserAttributesRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeleteUserAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest,
      DeleteUserAttributesResponse
    ]("deleteUserAttributes", api.deleteUserAttributes)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.DeleteUserAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def adminResetUserPassword(request: AdminResetUserPasswordRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminResetUserPasswordResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordRequest,
      AdminResetUserPasswordResponse
    ]("adminResetUserPassword", api.adminResetUserPassword)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AdminResetUserPasswordResponse.wrap
    ).provideEnvironment(r)
    def addCustomAttributes(request: AddCustomAttributesRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AddCustomAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest,
      AddCustomAttributesResponse
    ]("addCustomAttributes", api.addCustomAttributes)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.AddCustomAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def adminUserGlobalSignOut(request: AdminUserGlobalSignOutRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutRequest,
      AdminUserGlobalSignOutResponse
    ]("adminUserGlobalSignOut", api.adminUserGlobalSignOut)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse.wrap
    ).provideEnvironment(r)
    def getUICustomization(request: GetUiCustomizationRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.GetUiCustomizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest,
      GetUiCustomizationResponse
    ]("getUICustomization", api.getUICustomization)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.GetUiCustomizationResponse.wrap
      )
      .provideEnvironment(r)
    def createResourceServer(request: CreateResourceServerRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.CreateResourceServerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest,
      CreateResourceServerResponse
    ]("createResourceServer", api.createResourceServer)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.CreateResourceServerResponse.wrap
      )
      .provideEnvironment(r)
    def adminDisableUser(request: AdminDisableUserRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminDisableUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest,
      AdminDisableUserResponse
    ]("adminDisableUser", api.adminDisableUser)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.AdminDisableUserResponse.wrap)
      .provideEnvironment(r)
    def respondToAuthChallenge(request: RespondToAuthChallengeRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest,
      RespondToAuthChallengeResponse
    ]("respondToAuthChallenge", api.respondToAuthChallenge)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeResponse.wrap
    ).provideEnvironment(r)
    def getUser(request: GetUserRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.GetUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest,
      GetUserResponse
    ]("getUser", api.getUser)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.GetUserResponse.wrap)
      .provideEnvironment(r)
    def deleteResourceServer(
        request: DeleteResourceServerRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest,
      DeleteResourceServerResponse
    ]("deleteResourceServer", api.deleteResourceServer)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listGroups(request: ListGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest,
      ListGroupsResponse,
      GroupType
    ](
      "listGroups",
      api.listGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.groups().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cognitoidentityprovider.model.GroupType.wrap(item))
      .provideEnvironment(r)
    def listGroupsPaginated(request: ListGroupsRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ListGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest,
      ListGroupsResponse
    ]("listGroups", api.listGroups)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.ListGroupsResponse.wrap)
      .provideEnvironment(r)
    def listDevices(request: ListDevicesRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ListDevicesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest,
      ListDevicesResponse
    ]("listDevices", api.listDevices)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.ListDevicesResponse.wrap)
      .provideEnvironment(r)
    def verifySoftwareToken(request: VerifySoftwareTokenRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest,
      VerifySoftwareTokenResponse
    ]("verifySoftwareToken", api.verifySoftwareToken)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponse.wrap
      )
      .provideEnvironment(r)
    def adminDisableProviderForUser(
        request: AdminDisableProviderForUserRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest,
      AdminDisableProviderForUserResponse
    ]("adminDisableProviderForUser", api.adminDisableProviderForUser)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AdminDisableProviderForUserResponse.wrap
    ).provideEnvironment(r)
    def forgotPassword(request: ForgotPasswordRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ForgotPasswordResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordRequest,
      ForgotPasswordResponse
    ]("forgotPassword", api.forgotPassword)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.ForgotPasswordResponse.wrap)
      .provideEnvironment(r)
    def updateAuthEventFeedback(request: UpdateAuthEventFeedbackRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest,
      UpdateAuthEventFeedbackResponse
    ]("updateAuthEventFeedback", api.updateAuthEventFeedback)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse.wrap
    ).provideEnvironment(r)
    def updateIdentityProvider(request: UpdateIdentityProviderRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.UpdateIdentityProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest,
      UpdateIdentityProviderResponse
    ]("updateIdentityProvider", api.updateIdentityProvider)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.UpdateIdentityProviderResponse.wrap
    ).provideEnvironment(r)
    def listUserPoolClients(request: ListUserPoolClientsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolClientDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest,
      ListUserPoolClientsResponse,
      UserPoolClientDescription
    ](
      "listUserPoolClients",
      api.listUserPoolClients,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.userPoolClients().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.cognitoidentityprovider.model.UserPoolClientDescription
          .wrap(item)
      )
      .provideEnvironment(r)
    def listUserPoolClientsPaginated(request: ListUserPoolClientsRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ListUserPoolClientsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest,
      ListUserPoolClientsResponse
    ]("listUserPoolClients", api.listUserPoolClients)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.ListUserPoolClientsResponse.wrap
      )
      .provideEnvironment(r)
    def startUserImportJob(request: StartUserImportJobRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.StartUserImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobRequest,
      StartUserImportJobResponse
    ]("startUserImportJob", api.startUserImportJob)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.StartUserImportJobResponse.wrap
      )
      .provideEnvironment(r)
    def updateUserAttributes(request: UpdateUserAttributesRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.UpdateUserAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest,
      UpdateUserAttributesResponse
    ]("updateUserAttributes", api.updateUserAttributes)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.UpdateUserAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def adminListUserAuthEvents(
        request: AdminListUserAuthEventsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest,
      AdminListUserAuthEventsResponse,
      AuthEventType
    ](
      "adminListUserAuthEvents",
      api.adminListUserAuthEvents,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.authEvents().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.cognitoidentityprovider.model.AuthEventType.wrap(item)
      )
      .provideEnvironment(r)
    def adminListUserAuthEventsPaginated(
        request: AdminListUserAuthEventsRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest,
      AdminListUserAuthEventsResponse
    ]("adminListUserAuthEvents", api.adminListUserAuthEvents)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse.wrap
    ).provideEnvironment(r)
    def listIdentityProviders(request: ListIdentityProvidersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.ProviderDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest,
      ListIdentityProvidersResponse,
      ProviderDescription
    ](
      "listIdentityProviders",
      api.listIdentityProviders,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.providers().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.cognitoidentityprovider.model.ProviderDescription.wrap(item)
      )
      .provideEnvironment(r)
    def listIdentityProvidersPaginated(
        request: ListIdentityProvidersRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ListIdentityProvidersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest,
      ListIdentityProvidersResponse
    ]("listIdentityProviders", api.listIdentityProviders)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.ListIdentityProvidersResponse.wrap
    ).provideEnvironment(r)
    def listUserImportJobs(request: ListUserImportJobsRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ListUserImportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest,
      ListUserImportJobsResponse
    ]("listUserImportJobs", api.listUserImportJobs)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.ListUserImportJobsResponse.wrap
      )
      .provideEnvironment(r)
    def adminCreateUser(request: AdminCreateUserRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminCreateUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest,
      AdminCreateUserResponse
    ]("adminCreateUser", api.adminCreateUser)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.AdminCreateUserResponse.wrap)
      .provideEnvironment(r)
    def adminInitiateAuth(request: AdminInitiateAuthRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminInitiateAuthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest,
      AdminInitiateAuthResponse
    ]("adminInitiateAuth", api.adminInitiateAuth)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.AdminInitiateAuthResponse.wrap)
      .provideEnvironment(r)
    def confirmSignUp(request: ConfirmSignUpRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ConfirmSignUpResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpRequest,
      ConfirmSignUpResponse
    ]("confirmSignUp", api.confirmSignUp)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.ConfirmSignUpResponse.wrap)
      .provideEnvironment(r)
    def adminGetDevice(request: AdminGetDeviceRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminGetDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest,
      AdminGetDeviceResponse
    ]("adminGetDevice", api.adminGetDevice)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.AdminGetDeviceResponse.wrap)
      .provideEnvironment(r)
    def adminLinkProviderForUser(request: AdminLinkProviderForUserRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminLinkProviderForUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest,
      AdminLinkProviderForUserResponse
    ]("adminLinkProviderForUser", api.adminLinkProviderForUser)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AdminLinkProviderForUserResponse.wrap
    ).provideEnvironment(r)
    def confirmForgotPassword(request: ConfirmForgotPasswordRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ConfirmForgotPasswordResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest,
      ConfirmForgotPasswordResponse
    ]("confirmForgotPassword", api.confirmForgotPassword)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.ConfirmForgotPasswordResponse.wrap
    ).provideEnvironment(r)
    def setRiskConfiguration(request: SetRiskConfigurationRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.SetRiskConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest,
      SetRiskConfigurationResponse
    ]("setRiskConfiguration", api.setRiskConfiguration)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.SetRiskConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def forgetDevice(request: ForgetDeviceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest,
        ForgetDeviceResponse
      ]("forgetDevice", api.forgetDevice)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteUserPool(request: DeleteUserPoolRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest,
        DeleteUserPoolResponse
      ]("deleteUserPool", api.deleteUserPool)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listResourceServers(request: ListResourceServersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest,
      ListResourceServersResponse,
      ResourceServerType
    ](
      "listResourceServers",
      api.listResourceServers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resourceServers().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.cognitoidentityprovider.model.ResourceServerType.wrap(item)
      )
      .provideEnvironment(r)
    def listResourceServersPaginated(request: ListResourceServersRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ListResourceServersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest,
      ListResourceServersResponse
    ]("listResourceServers", api.listResourceServers)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.ListResourceServersResponse.wrap
      )
      .provideEnvironment(r)
    def describeUserImportJob(request: DescribeUserImportJobRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.DescribeUserImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest,
      DescribeUserImportJobResponse
    ]("describeUserImportJob", api.describeUserImportJob)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.DescribeUserImportJobResponse.wrap
    ).provideEnvironment(r)
    def deleteUserPoolDomain(request: DeleteUserPoolDomainRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeleteUserPoolDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest,
      DeleteUserPoolDomainResponse
    ]("deleteUserPoolDomain", api.deleteUserPoolDomain)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.DeleteUserPoolDomainResponse.wrap
      )
      .provideEnvironment(r)
    def setUserSettings(request: SetUserSettingsRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.SetUserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest,
      SetUserSettingsResponse
    ]("setUserSettings", api.setUserSettings)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.SetUserSettingsResponse.wrap)
      .provideEnvironment(r)
    def adminDeleteUser(request: AdminDeleteUserRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserRequest,
        AdminDeleteUserResponse
      ]("adminDeleteUser", api.adminDeleteUser)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def adminRespondToAuthChallenge(
        request: AdminRespondToAuthChallengeRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest,
      AdminRespondToAuthChallengeResponse
    ]("adminRespondToAuthChallenge", api.adminRespondToAuthChallenge)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse.wrap
    ).provideEnvironment(r)
    def createGroup(request: CreateGroupRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.CreateGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupRequest,
      CreateGroupResponse
    ]("createGroup", api.createGroup)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.CreateGroupResponse.wrap)
      .provideEnvironment(r)
    def adminAddUserToGroup(
        request: AdminAddUserToGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest,
      AdminAddUserToGroupResponse
    ]("adminAddUserToGroup", api.adminAddUserToGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def adminSetUserPassword(request: AdminSetUserPasswordRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminSetUserPasswordResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest,
      AdminSetUserPasswordResponse
    ]("adminSetUserPassword", api.adminSetUserPassword)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.AdminSetUserPasswordResponse.wrap
      )
      .provideEnvironment(r)
    def setUserMFAPreference(request: SetUserMfaPreferenceRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.SetUserMfaPreferenceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest,
      SetUserMfaPreferenceResponse
    ]("setUserMFAPreference", api.setUserMFAPreference)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.SetUserMfaPreferenceResponse.wrap
      )
      .provideEnvironment(r)
    def updateUserPoolDomain(request: UpdateUserPoolDomainRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest,
      UpdateUserPoolDomainResponse
    ]("updateUserPoolDomain", api.updateUserPoolDomain)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainResponse.wrap
      )
      .provideEnvironment(r)
    def setUICustomization(request: SetUiCustomizationRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.SetUiCustomizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest,
      SetUiCustomizationResponse
    ]("setUICustomization", api.setUICustomization)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.SetUiCustomizationResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.ListTagsForResourceResponse.wrap
      )
      .provideEnvironment(r)
    def updateGroup(request: UpdateGroupRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.UpdateGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest,
      UpdateGroupResponse
    ]("updateGroup", api.updateGroup)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.UpdateGroupResponse.wrap)
      .provideEnvironment(r)
    def confirmDevice(request: ConfirmDeviceRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest,
      ConfirmDeviceResponse
    ]("confirmDevice", api.confirmDevice)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def adminDeleteUserAttributes(
        request: AdminDeleteUserAttributesRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest,
      AdminDeleteUserAttributesResponse
    ]("adminDeleteUserAttributes", api.adminDeleteUserAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse.wrap
    ).provideEnvironment(r)
    def adminForgetDevice(
        request: AdminForgetDeviceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest,
      AdminForgetDeviceResponse
    ]("adminForgetDevice", api.adminForgetDevice)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def createUserPool(request: CreateUserPoolRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.CreateUserPoolResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest,
      CreateUserPoolResponse
    ]("createUserPool", api.createUserPool)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.CreateUserPoolResponse.wrap)
      .provideEnvironment(r)
    def deleteUser(request: DeleteUserRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest,
        DeleteUserResponse
      ]("deleteUser", api.deleteUser)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createUserImportJob(request: CreateUserImportJobRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.CreateUserImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest,
      CreateUserImportJobResponse
    ]("createUserImportJob", api.createUserImportJob)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.CreateUserImportJobResponse.wrap
      )
      .provideEnvironment(r)
    def getGroup(request: GetGroupRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.GetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest,
      GetGroupResponse
    ]("getGroup", api.getGroup)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.GetGroupResponse.wrap)
      .provideEnvironment(r)
    def createUserPoolClient(request: CreateUserPoolClientRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.CreateUserPoolClientResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientRequest,
      CreateUserPoolClientResponse
    ]("createUserPoolClient", api.createUserPoolClient)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.CreateUserPoolClientResponse.wrap
      )
      .provideEnvironment(r)
    def updateUserPool(request: UpdateUserPoolRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.UpdateUserPoolResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest,
      UpdateUserPoolResponse
    ]("updateUserPool", api.updateUserPool)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.UpdateUserPoolResponse.wrap)
      .provideEnvironment(r)
    def updateDeviceStatus(request: UpdateDeviceStatusRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.UpdateDeviceStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest,
      UpdateDeviceStatusResponse
    ]("updateDeviceStatus", api.updateDeviceStatus)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.UpdateDeviceStatusResponse.wrap
      )
      .provideEnvironment(r)
    def describeUserPoolClient(request: DescribeUserPoolClientRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest,
      DescribeUserPoolClientResponse
    ]("describeUserPoolClient", api.describeUserPoolClient)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientResponse.wrap
    ).provideEnvironment(r)
    def getCSVHeader(request: GetCsvHeaderRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.GetCsvHeaderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest,
      GetCsvHeaderResponse
    ]("getCSVHeader", api.getCSVHeader)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.GetCsvHeaderResponse.wrap)
      .provideEnvironment(r)
    def describeResourceServer(request: DescribeResourceServerRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.DescribeResourceServerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest,
      DescribeResourceServerResponse
    ]("describeResourceServer", api.describeResourceServer)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.DescribeResourceServerResponse.wrap
    ).provideEnvironment(r)
    def setUserPoolMfaConfig(request: SetUserPoolMfaConfigRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest,
      SetUserPoolMfaConfigResponse
    ]("setUserPoolMfaConfig", api.setUserPoolMfaConfig)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse.wrap
      )
      .provideEnvironment(r)
    def describeRiskConfiguration(
        request: DescribeRiskConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest,
      DescribeRiskConfigurationResponse
    ]("describeRiskConfiguration", api.describeRiskConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationResponse.wrap
    ).provideEnvironment(r)
    def listUserPools(request: ListUserPoolsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest,
      ListUserPoolsResponse,
      UserPoolDescriptionType
    ](
      "listUserPools",
      api.listUserPools,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.userPools().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.wrap(item)
      )
      .provideEnvironment(r)
    def listUserPoolsPaginated(request: ListUserPoolsRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest,
      ListUserPoolsResponse
    ]("listUserPools", api.listUserPools)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse.wrap)
      .provideEnvironment(r)
    def adminListDevices(request: AdminListDevicesRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminListDevicesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest,
      AdminListDevicesResponse
    ]("adminListDevices", api.adminListDevices)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.AdminListDevicesResponse.wrap)
      .provideEnvironment(r)
    def getDevice(request: GetDeviceRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.GetDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest,
      GetDeviceResponse
    ]("getDevice", api.getDevice)(request.buildAwsValue())
      .map(zio.aws.cognitoidentityprovider.model.GetDeviceResponse.wrap)
      .provideEnvironment(r)
    def adminSetUserMFAPreference(
        request: AdminSetUserMfaPreferenceRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest,
      AdminSetUserMfaPreferenceResponse
    ]("adminSetUserMFAPreference", api.adminSetUserMFAPreference)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse.wrap
    ).provideEnvironment(r)
    def updateResourceServer(request: UpdateResourceServerRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.UpdateResourceServerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerRequest,
      UpdateResourceServerResponse
    ]("updateResourceServer", api.updateResourceServer)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.UpdateResourceServerResponse.wrap
      )
      .provideEnvironment(r)
    def verifyUserAttribute(request: VerifyUserAttributeRequest): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.VerifyUserAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest,
      VerifyUserAttributeResponse
    ]("verifyUserAttribute", api.verifyUserAttribute)(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentityprovider.model.VerifyUserAttributeResponse.wrap
      )
      .provideEnvironment(r)
    def getIdentityProviderByIdentifier(
        request: GetIdentityProviderByIdentifierRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest,
      GetIdentityProviderByIdentifierResponse
    ]("getIdentityProviderByIdentifier", api.getIdentityProviderByIdentifier)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse.wrap
    ).provideEnvironment(r)
  }
  def adminConfirmSignUp(request: AdminConfirmSignUpRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminConfirmSignUpResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminConfirmSignUp(request))
  def createIdentityProvider(request: CreateIdentityProviderRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateIdentityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIdentityProvider(request))
  def adminEnableUser(request: AdminEnableUserRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminEnableUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminEnableUser(request))
  def revokeToken(request: RevokeTokenRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.RevokeTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeToken(request))
  def stopUserImportJob(request: StopUserImportJobRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.StopUserImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopUserImportJob(request))
  def adminRemoveUserFromGroup(request: AdminRemoveUserFromGroupRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.adminRemoveUserFromGroup(request))
  def describeUserPoolDomain(request: DescribeUserPoolDomainRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUserPoolDomain(request))
  def listUsers(request: ListUsersRequest): ZStream[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
  ] = ZStream.serviceWithStream(_.listUsers(request))
  def listUsersPaginated(request: ListUsersRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUsersPaginated(request))
  def listUsersInGroup(request: ListUsersInGroupRequest): ZStream[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
  ] = ZStream.serviceWithStream(_.listUsersInGroup(request))
  def listUsersInGroupPaginated(request: ListUsersInGroupRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListUsersInGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUsersInGroupPaginated(request))
  def globalSignOut(request: GlobalSignOutRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GlobalSignOutResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.globalSignOut(request))
  def adminGetUser(request: AdminGetUserRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminGetUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminGetUser(request))
  def createUserPoolDomain(request: CreateUserPoolDomainRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUserPoolDomain(request))
  def associateSoftwareToken(request: AssociateSoftwareTokenRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateSoftwareToken(request))
  def adminUpdateAuthEventFeedback(
      request: AdminUpdateAuthEventFeedbackRequest
  ): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminUpdateAuthEventFeedback(request))
  def describeUserPool(request: DescribeUserPoolRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeUserPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUserPool(request))
  def describeIdentityProvider(request: DescribeIdentityProviderRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeIdentityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIdentityProvider(request))
  def adminUpdateDeviceStatus(request: AdminUpdateDeviceStatusRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminUpdateDeviceStatus(request))
  def adminUpdateUserAttributes(request: AdminUpdateUserAttributesRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminUpdateUserAttributes(request))
  def resendConfirmationCode(request: ResendConfirmationCodeRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resendConfirmationCode(request))
  def signUp(request: SignUpRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.SignUpResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.signUp(request))
  def deleteIdentityProvider(request: DeleteIdentityProviderRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteIdentityProvider(request))
  def getUserAttributeVerificationCode(
      request: GetUserAttributeVerificationCodeRequest
  ): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUserAttributeVerificationCode(request))
  def deleteUserPoolClient(request: DeleteUserPoolClientRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteUserPoolClient(request))
  def deleteGroup(request: DeleteGroupRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteGroup(request))
  def adminSetUserSettings(request: AdminSetUserSettingsRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminSetUserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminSetUserSettings(request))
  def getSigningCertificate(request: GetSigningCertificateRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSigningCertificate(request))
  def getUserPoolMfaConfig(request: GetUserPoolMfaConfigRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUserPoolMfaConfig(request))
  def updateUserPoolClient(request: UpdateUserPoolClientRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateUserPoolClientResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUserPoolClient(request))
  def initiateAuth(request: InitiateAuthRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.InitiateAuthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.initiateAuth(request))
  def changePassword(request: ChangePasswordRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ChangePasswordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.changePassword(request))
  def adminListGroupsForUser(request: AdminListGroupsForUserRequest): ZStream[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
  ] = ZStream.serviceWithStream(_.adminListGroupsForUser(request))
  def adminListGroupsForUserPaginated(
      request: AdminListGroupsForUserRequest
  ): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminListGroupsForUserPaginated(request))
  def deleteUserAttributes(request: DeleteUserAttributesRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.DeleteUserAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUserAttributes(request))
  def adminResetUserPassword(request: AdminResetUserPasswordRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminResetUserPasswordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminResetUserPassword(request))
  def addCustomAttributes(request: AddCustomAttributesRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AddCustomAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addCustomAttributes(request))
  def adminUserGlobalSignOut(request: AdminUserGlobalSignOutRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminUserGlobalSignOut(request))
  def getUICustomization(request: GetUiCustomizationRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetUiCustomizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUICustomization(request))
  def createResourceServer(request: CreateResourceServerRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateResourceServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResourceServer(request))
  def adminDisableUser(request: AdminDisableUserRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminDisableUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminDisableUser(request))
  def respondToAuthChallenge(request: RespondToAuthChallengeRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.respondToAuthChallenge(request))
  def getUser(request: GetUserRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUser(request))
  def deleteResourceServer(request: DeleteResourceServerRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteResourceServer(request))
  def listGroups(request: ListGroupsRequest): ZStream[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
  ] = ZStream.serviceWithStream(_.listGroups(request))
  def listGroupsPaginated(request: ListGroupsRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGroupsPaginated(request))
  def listDevices(request: ListDevicesRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDevices(request))
  def verifySoftwareToken(request: VerifySoftwareTokenRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.verifySoftwareToken(request))
  def adminDisableProviderForUser(
      request: AdminDisableProviderForUserRequest
  ): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.adminDisableProviderForUser(request))
  def forgotPassword(request: ForgotPasswordRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ForgotPasswordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.forgotPassword(request))
  def updateAuthEventFeedback(request: UpdateAuthEventFeedbackRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAuthEventFeedback(request))
  def updateIdentityProvider(request: UpdateIdentityProviderRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateIdentityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIdentityProvider(request))
  def listUserPoolClients(request: ListUserPoolClientsRequest): ZStream[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UserPoolClientDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.listUserPoolClients(request))
  def listUserPoolClientsPaginated(request: ListUserPoolClientsRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListUserPoolClientsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUserPoolClientsPaginated(request))
  def startUserImportJob(request: StartUserImportJobRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.StartUserImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startUserImportJob(request))
  def updateUserAttributes(request: UpdateUserAttributesRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateUserAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUserAttributes(request))
  def adminListUserAuthEvents(request: AdminListUserAuthEventsRequest): ZStream[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly
  ] = ZStream.serviceWithStream(_.adminListUserAuthEvents(request))
  def adminListUserAuthEventsPaginated(
      request: AdminListUserAuthEventsRequest
  ): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminListUserAuthEventsPaginated(request))
  def listIdentityProviders(request: ListIdentityProvidersRequest): ZStream[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ProviderDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.listIdentityProviders(request))
  def listIdentityProvidersPaginated(
      request: ListIdentityProvidersRequest
  ): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListIdentityProvidersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIdentityProvidersPaginated(request))
  def listUserImportJobs(request: ListUserImportJobsRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListUserImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUserImportJobs(request))
  def adminCreateUser(request: AdminCreateUserRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminCreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminCreateUser(request))
  def adminInitiateAuth(request: AdminInitiateAuthRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminInitiateAuthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminInitiateAuth(request))
  def confirmSignUp(request: ConfirmSignUpRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ConfirmSignUpResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.confirmSignUp(request))
  def adminGetDevice(request: AdminGetDeviceRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminGetDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminGetDevice(request))
  def adminLinkProviderForUser(request: AdminLinkProviderForUserRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminLinkProviderForUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminLinkProviderForUser(request))
  def confirmForgotPassword(request: ConfirmForgotPasswordRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ConfirmForgotPasswordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.confirmForgotPassword(request))
  def setRiskConfiguration(request: SetRiskConfigurationRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.SetRiskConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setRiskConfiguration(request))
  def forgetDevice(request: ForgetDeviceRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.forgetDevice(request))
  def deleteUserPool(request: DeleteUserPoolRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteUserPool(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listResourceServers(request: ListResourceServersRequest): ZStream[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly
  ] = ZStream.serviceWithStream(_.listResourceServers(request))
  def listResourceServersPaginated(request: ListResourceServersRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListResourceServersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourceServersPaginated(request))
  def describeUserImportJob(request: DescribeUserImportJobRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeUserImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUserImportJob(request))
  def deleteUserPoolDomain(request: DeleteUserPoolDomainRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.DeleteUserPoolDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUserPoolDomain(request))
  def setUserSettings(request: SetUserSettingsRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.SetUserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setUserSettings(request))
  def adminDeleteUser(request: AdminDeleteUserRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.adminDeleteUser(request))
  def adminRespondToAuthChallenge(
      request: AdminRespondToAuthChallengeRequest
  ): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminRespondToAuthChallenge(request))
  def createGroup(request: CreateGroupRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGroup(request))
  def adminAddUserToGroup(request: AdminAddUserToGroupRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.adminAddUserToGroup(request))
  def adminSetUserPassword(request: AdminSetUserPasswordRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminSetUserPasswordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminSetUserPassword(request))
  def setUserMFAPreference(request: SetUserMfaPreferenceRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.SetUserMfaPreferenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setUserMFAPreference(request))
  def updateUserPoolDomain(request: UpdateUserPoolDomainRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUserPoolDomain(request))
  def setUICustomization(request: SetUiCustomizationRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.SetUiCustomizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setUICustomization(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def updateGroup(request: UpdateGroupRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGroup(request))
  def confirmDevice(request: ConfirmDeviceRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.confirmDevice(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def adminDeleteUserAttributes(request: AdminDeleteUserAttributesRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminDeleteUserAttributes(request))
  def adminForgetDevice(request: AdminForgetDeviceRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.adminForgetDevice(request))
  def createUserPool(request: CreateUserPoolRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateUserPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUserPool(request))
  def deleteUser(request: DeleteUserRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteUser(request))
  def createUserImportJob(request: CreateUserImportJobRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateUserImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUserImportJob(request))
  def getGroup(request: GetGroupRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGroup(request))
  def createUserPoolClient(request: CreateUserPoolClientRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.CreateUserPoolClientResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUserPoolClient(request))
  def updateUserPool(request: UpdateUserPoolRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateUserPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUserPool(request))
  def updateDeviceStatus(request: UpdateDeviceStatusRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateDeviceStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDeviceStatus(request))
  def describeUserPoolClient(request: DescribeUserPoolClientRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUserPoolClient(request))
  def getCSVHeader(request: GetCsvHeaderRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetCsvHeaderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCSVHeader(request))
  def describeResourceServer(request: DescribeResourceServerRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeResourceServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeResourceServer(request))
  def setUserPoolMfaConfig(request: SetUserPoolMfaConfigRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setUserPoolMfaConfig(request))
  def describeRiskConfiguration(request: DescribeRiskConfigurationRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRiskConfiguration(request))
  def listUserPools(request: ListUserPoolsRequest): ZStream[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly
  ] = ZStream.serviceWithStream(_.listUserPools(request))
  def listUserPoolsPaginated(request: ListUserPoolsRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUserPoolsPaginated(request))
  def adminListDevices(request: AdminListDevicesRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminListDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminListDevices(request))
  def getDevice(request: GetDeviceRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDevice(request))
  def adminSetUserMFAPreference(request: AdminSetUserMfaPreferenceRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.adminSetUserMFAPreference(request))
  def updateResourceServer(request: UpdateResourceServerRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.UpdateResourceServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResourceServer(request))
  def verifyUserAttribute(request: VerifyUserAttributeRequest): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.VerifyUserAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.verifyUserAttribute(request))
  def getIdentityProviderByIdentifier(
      request: GetIdentityProviderByIdentifierRequest
  ): ZIO[
    zio.aws.cognitoidentityprovider.CognitoIdentityProvider,
    AwsError,
    zio.aws.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIdentityProviderByIdentifier(request))
}
