package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{ArnType, StringType}
import scala.jdk.CollectionConverters._
final case class NotifyConfigurationType(
    from: Optional[StringType] = Optional.Absent,
    replyTo: Optional[StringType] = Optional.Absent,
    sourceArn: ArnType,
    blockEmail: Optional[
      zio.aws.cognitoidentityprovider.model.NotifyEmailType
    ] = Optional.Absent,
    noActionEmail: Optional[
      zio.aws.cognitoidentityprovider.model.NotifyEmailType
    ] = Optional.Absent,
    mfaEmail: Optional[zio.aws.cognitoidentityprovider.model.NotifyEmailType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.NotifyConfigurationType = {
    import NotifyConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.NotifyConfigurationType
      .builder()
      .optionallyWith(from.map(value => value: java.lang.String))(_.from)
      .optionallyWith(replyTo.map(value => value: java.lang.String))(_.replyTo)
      .sourceArn(ArnType.unwrap(sourceArn): java.lang.String)
      .optionallyWith(blockEmail.map(value => value.buildAwsValue()))(
        _.blockEmail
      )
      .optionallyWith(noActionEmail.map(value => value.buildAwsValue()))(
        _.noActionEmail
      )
      .optionallyWith(mfaEmail.map(value => value.buildAwsValue()))(_.mfaEmail)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.NotifyConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.NotifyConfigurationType
      .wrap(buildAwsValue())
}
object NotifyConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.NotifyConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.NotifyConfigurationType =
      zio.aws.cognitoidentityprovider.model.NotifyConfigurationType(
        from.map(value => value),
        replyTo.map(value => value),
        sourceArn,
        blockEmail.map(value => value.asEditable),
        noActionEmail.map(value => value.asEditable),
        mfaEmail.map(value => value.asEditable)
      )
    def from: Optional[StringType]
    def replyTo: Optional[StringType]
    def sourceArn: ArnType
    def blockEmail: Optional[
      zio.aws.cognitoidentityprovider.model.NotifyEmailType.ReadOnly
    ]
    def noActionEmail: Optional[
      zio.aws.cognitoidentityprovider.model.NotifyEmailType.ReadOnly
    ]
    def mfaEmail: Optional[
      zio.aws.cognitoidentityprovider.model.NotifyEmailType.ReadOnly
    ]
    def getFrom: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("from", from)
    def getReplyTo: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("replyTo", replyTo)
    def getSourceArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(sourceArn)
    def getBlockEmail: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.NotifyEmailType.ReadOnly
    ] = AwsError.unwrapOptionField("blockEmail", blockEmail)
    def getNoActionEmail: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.NotifyEmailType.ReadOnly
    ] = AwsError.unwrapOptionField("noActionEmail", noActionEmail)
    def getMfaEmail: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.NotifyEmailType.ReadOnly
    ] = AwsError.unwrapOptionField("mfaEmail", mfaEmail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.NotifyConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.NotifyConfigurationType.ReadOnly {
    override val from: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.from())
      .map(value => value: StringType)
    override val replyTo: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.replyTo())
      .map(value => value: StringType)
    override val sourceArn: ArnType =
      zio.aws.cognitoidentityprovider.model.primitives.ArnType(impl.sourceArn())
    override val blockEmail: Optional[
      zio.aws.cognitoidentityprovider.model.NotifyEmailType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blockEmail())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.NotifyEmailType.wrap(value)
      )
    override val noActionEmail: Optional[
      zio.aws.cognitoidentityprovider.model.NotifyEmailType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.noActionEmail())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.NotifyEmailType.wrap(value)
      )
    override val mfaEmail: Optional[
      zio.aws.cognitoidentityprovider.model.NotifyEmailType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mfaEmail())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.NotifyEmailType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.NotifyConfigurationType
  ): zio.aws.cognitoidentityprovider.model.NotifyConfigurationType.ReadOnly =
    new Wrapper(impl)
}
