package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeIdentityProviderResponse(
    identityProvider: zio.aws.cognitoidentityprovider.model.IdentityProviderType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse = {
    import DescribeIdentityProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse
      .builder()
      .identityProvider(identityProvider.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeIdentityProviderResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeIdentityProviderResponse
      .wrap(buildAwsValue())
}
object DescribeIdentityProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeIdentityProviderResponse =
      zio.aws.cognitoidentityprovider.model
        .DescribeIdentityProviderResponse(identityProvider.asEditable)
    def identityProvider
        : zio.aws.cognitoidentityprovider.model.IdentityProviderType.ReadOnly
    def getIdentityProvider: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.IdentityProviderType.ReadOnly
    ] = ZIO.succeed(identityProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse
  ) extends zio.aws.cognitoidentityprovider.model.DescribeIdentityProviderResponse.ReadOnly {
    override val identityProvider
        : zio.aws.cognitoidentityprovider.model.IdentityProviderType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.IdentityProviderType
        .wrap(impl.identityProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse
  ): zio.aws.cognitoidentityprovider.model.DescribeIdentityProviderResponse.ReadOnly =
    new Wrapper(impl)
}
