package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class RiskExceptionConfigurationType(
    blockedIPRangeList: Optional[Iterable[StringType]] = Optional.Absent,
    skippedIPRangeList: Optional[Iterable[StringType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.RiskExceptionConfigurationType = {
    import RiskExceptionConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.RiskExceptionConfigurationType
      .builder()
      .optionallyWith(
        blockedIPRangeList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.blockedIPRangeList)
      .optionallyWith(
        skippedIPRangeList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.skippedIPRangeList)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType
      .wrap(buildAwsValue())
}
object RiskExceptionConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.RiskExceptionConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType =
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType(
        blockedIPRangeList.map(value => value),
        skippedIPRangeList.map(value => value)
      )
    def blockedIPRangeList: Optional[List[StringType]]
    def skippedIPRangeList: Optional[List[StringType]]
    def getBlockedIPRangeList: ZIO[Any, AwsError, List[StringType]] =
      AwsError.unwrapOptionField("blockedIPRangeList", blockedIPRangeList)
    def getSkippedIPRangeList: ZIO[Any, AwsError, List[StringType]] =
      AwsError.unwrapOptionField("skippedIPRangeList", skippedIPRangeList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RiskExceptionConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType.ReadOnly {
    override val blockedIPRangeList: Optional[List[StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockedIPRangeList())
        .map(value =>
          value.asScala.map { item =>
            item: StringType
          }.toList
        )
    override val skippedIPRangeList: Optional[List[StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skippedIPRangeList())
        .map(value =>
          value.asScala.map { item =>
            item: StringType
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RiskExceptionConfigurationType
  ): zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType.ReadOnly =
    new Wrapper(impl)
}
