package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  ArnType,
  PrecedenceType,
  DateType,
  UserPoolIdType,
  GroupNameType,
  DescriptionType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GroupType(
    groupName: Optional[GroupNameType] = Optional.Absent,
    userPoolId: Optional[UserPoolIdType] = Optional.Absent,
    description: Optional[DescriptionType] = Optional.Absent,
    roleArn: Optional[ArnType] = Optional.Absent,
    precedence: Optional[PrecedenceType] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType = {
    import GroupType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType
      .builder()
      .optionallyWith(
        groupName.map(value => GroupNameType.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        roleArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        precedence.map(value => PrecedenceType.unwrap(value): Integer)
      )(_.precedence)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GroupType.wrap(buildAwsValue())
}
object GroupType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.GroupType =
      zio.aws.cognitoidentityprovider.model.GroupType(
        groupName.map(value => value),
        userPoolId.map(value => value),
        description.map(value => value),
        roleArn.map(value => value),
        precedence.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value)
      )
    def groupName: Optional[GroupNameType]
    def userPoolId: Optional[UserPoolIdType]
    def description: Optional[DescriptionType]
    def roleArn: Optional[ArnType]
    def precedence: Optional[PrecedenceType]
    def lastModifiedDate: Optional[DateType]
    def creationDate: Optional[DateType]
    def getGroupName: ZIO[Any, AwsError, GroupNameType] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getPrecedence: ZIO[Any, AwsError, PrecedenceType] =
      AwsError.unwrapOptionField("precedence", precedence)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType
  ) extends zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly {
    override val groupName: Optional[GroupNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.GroupNameType(value)
      )
    override val userPoolId: Optional[UserPoolIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val description: Optional[DescriptionType] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DescriptionType(value)
      )
    override val roleArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val precedence: Optional[PrecedenceType] = zio.aws.core.internal
      .optionalFromNullable(impl.precedence())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PrecedenceType(value)
      )
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType
  ): zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly = new Wrapper(
    impl
  )
}
