package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.SmsVerificationMessageType
import scala.jdk.CollectionConverters._
final case class SmsMfaConfigType(
    smsAuthenticationMessage: Optional[SmsVerificationMessageType] =
      Optional.Absent,
    smsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SmsMfaConfigType = {
    import SmsMfaConfigType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SmsMfaConfigType
      .builder()
      .optionallyWith(
        smsAuthenticationMessage.map(value =>
          SmsVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.smsAuthenticationMessage)
      .optionallyWith(smsConfiguration.map(value => value.buildAwsValue()))(
        _.smsConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.wrap(buildAwsValue())
}
object SmsMfaConfigType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SmsMfaConfigType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.SmsMfaConfigType =
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType(
        smsAuthenticationMessage.map(value => value),
        smsConfiguration.map(value => value.asEditable)
      )
    def smsAuthenticationMessage: Optional[SmsVerificationMessageType]
    def smsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ]
    def getSmsAuthenticationMessage
        : ZIO[Any, AwsError, SmsVerificationMessageType] = AwsError
      .unwrapOptionField("smsAuthenticationMessage", smsAuthenticationMessage)
    def getSmsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("smsConfiguration", smsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SmsMfaConfigType
  ) extends zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.ReadOnly {
    override val smsAuthenticationMessage
        : Optional[SmsVerificationMessageType] = zio.aws.core.internal
      .optionalFromNullable(impl.smsAuthenticationMessage())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .SmsVerificationMessageType(value)
      )
    override val smsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.smsConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SmsConfigurationType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SmsMfaConfigType
  ): zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.ReadOnly =
    new Wrapper(impl)
}
