package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetUserPoolMfaConfigResponse(
    smsMfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType
    ] = Optional.Absent,
    softwareTokenMfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
    ] = Optional.Absent,
    mfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse = {
    import SetUserPoolMfaConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse
      .builder()
      .optionallyWith(smsMfaConfiguration.map(value => value.buildAwsValue()))(
        _.smsMfaConfiguration
      )
      .optionallyWith(
        softwareTokenMfaConfiguration.map(value => value.buildAwsValue())
      )(_.softwareTokenMfaConfiguration)
      .optionallyWith(mfaConfiguration.map(value => value.unwrap))(
        _.mfaConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse
      .wrap(buildAwsValue())
}
object SetUserPoolMfaConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse =
      zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse(
        smsMfaConfiguration.map(value => value.asEditable),
        softwareTokenMfaConfiguration.map(value => value.asEditable),
        mfaConfiguration.map(value => value)
      )
    def smsMfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.ReadOnly
    ]
    def softwareTokenMfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType.ReadOnly
    ]
    def mfaConfiguration
        : Optional[zio.aws.cognitoidentityprovider.model.UserPoolMfaType]
    def getSmsMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("smsMfaConfiguration", smsMfaConfiguration)
    def getSoftwareTokenMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "softwareTokenMfaConfiguration",
      softwareTokenMfaConfiguration
    )
    def getMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = AwsError.unwrapOptionField("mfaConfiguration", mfaConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse
  ) extends zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse.ReadOnly {
    override val smsMfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.smsMfaConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.wrap(value)
      )
    override val softwareTokenMfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.softwareTokenMfaConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
          .wrap(value)
      )
    override val mfaConfiguration
        : Optional[zio.aws.cognitoidentityprovider.model.UserPoolMfaType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mfaConfiguration())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.UserPoolMfaType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse
  ): zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse.ReadOnly =
    new Wrapper(impl)
}
