package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{DateType, StringType}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class EventFeedbackType(
    feedbackValue: zio.aws.cognitoidentityprovider.model.FeedbackValueType,
    provider: StringType,
    feedbackDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.EventFeedbackType = {
    import EventFeedbackType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.EventFeedbackType
      .builder()
      .feedbackValue(feedbackValue.unwrap)
      .provider(provider: java.lang.String)
      .optionallyWith(
        feedbackDate.map(value => DateType.unwrap(value): Instant)
      )(_.feedbackDate)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.EventFeedbackType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.EventFeedbackType
      .wrap(buildAwsValue())
}
object EventFeedbackType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.EventFeedbackType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.EventFeedbackType =
      zio.aws.cognitoidentityprovider.model.EventFeedbackType(
        feedbackValue,
        provider,
        feedbackDate.map(value => value)
      )
    def feedbackValue: zio.aws.cognitoidentityprovider.model.FeedbackValueType
    def provider: StringType
    def feedbackDate: Optional[DateType]
    def getFeedbackValue: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.FeedbackValueType
    ] = ZIO.succeed(feedbackValue)
    def getProvider: ZIO[Any, Nothing, StringType] = ZIO.succeed(provider)
    def getFeedbackDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("feedbackDate", feedbackDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.EventFeedbackType
  ) extends zio.aws.cognitoidentityprovider.model.EventFeedbackType.ReadOnly {
    override val feedbackValue
        : zio.aws.cognitoidentityprovider.model.FeedbackValueType =
      zio.aws.cognitoidentityprovider.model.FeedbackValueType
        .wrap(impl.feedbackValue())
    override val provider: StringType = impl.provider(): StringType
    override val feedbackDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.feedbackDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.EventFeedbackType
  ): zio.aws.cognitoidentityprovider.model.EventFeedbackType.ReadOnly =
    new Wrapper(impl)
}
