package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  SessionType
}
import scala.jdk.CollectionConverters._
final case class AdminInitiateAuthResponse(
    challengeName: Optional[
      zio.aws.cognitoidentityprovider.model.ChallengeNameType
    ] = Optional.Absent,
    session: Optional[SessionType] = Optional.Absent,
    challengeParameters: Optional[Map[StringType, StringType]] =
      Optional.Absent,
    authenticationResult: Optional[
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse = {
    import AdminInitiateAuthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse
      .builder()
      .optionallyWith(challengeName.map(value => value.unwrap))(_.challengeName)
      .optionallyWith(
        session.map(value => SessionType.unwrap(value): java.lang.String)
      )(_.session)
      .optionallyWith(
        challengeParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.challengeParameters)
      .optionallyWith(authenticationResult.map(value => value.buildAwsValue()))(
        _.authenticationResult
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminInitiateAuthResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminInitiateAuthResponse
      .wrap(buildAwsValue())
}
object AdminInitiateAuthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminInitiateAuthResponse =
      zio.aws.cognitoidentityprovider.model.AdminInitiateAuthResponse(
        challengeName.map(value => value),
        session.map(value => value),
        challengeParameters.map(value => value),
        authenticationResult.map(value => value.asEditable)
      )
    def challengeName
        : Optional[zio.aws.cognitoidentityprovider.model.ChallengeNameType]
    def session: Optional[SessionType]
    def challengeParameters: Optional[Map[StringType, StringType]]
    def authenticationResult: Optional[
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly
    ]
    def getChallengeName: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.ChallengeNameType
    ] = AwsError.unwrapOptionField("challengeName", challengeName)
    def getSession: ZIO[Any, AwsError, SessionType] =
      AwsError.unwrapOptionField("session", session)
    def getChallengeParameters
        : ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("challengeParameters", challengeParameters)
    def getAuthenticationResult: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly
    ] = AwsError.unwrapOptionField("authenticationResult", authenticationResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse
  ) extends zio.aws.cognitoidentityprovider.model.AdminInitiateAuthResponse.ReadOnly {
    override val challengeName
        : Optional[zio.aws.cognitoidentityprovider.model.ChallengeNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.challengeName())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.ChallengeNameType.wrap(value)
        )
    override val session: Optional[SessionType] = zio.aws.core.internal
      .optionalFromNullable(impl.session())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SessionType(value)
      )
    override val challengeParameters: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.challengeParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
    override val authenticationResult: Optional[
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.authenticationResult())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AuthenticationResultType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse
  ): zio.aws.cognitoidentityprovider.model.AdminInitiateAuthResponse.ReadOnly =
    new Wrapper(impl)
}
