package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.AccountTakeoverActionNotifyType
import scala.jdk.CollectionConverters._
final case class AccountTakeoverActionType(
    sendNotification: AccountTakeoverActionNotifyType,
    eventAction: zio.aws.cognitoidentityprovider.model.AccountTakeoverEventActionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverActionType = {
    import AccountTakeoverActionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverActionType
      .builder()
      .sendNotification(
        AccountTakeoverActionNotifyType.unwrap(
          sendNotification
        ): java.lang.Boolean
      )
      .eventAction(eventAction.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType
      .wrap(buildAwsValue())
}
object AccountTakeoverActionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverActionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType =
      zio.aws.cognitoidentityprovider.model
        .AccountTakeoverActionType(sendNotification, eventAction)
    def sendNotification: AccountTakeoverActionNotifyType
    def eventAction
        : zio.aws.cognitoidentityprovider.model.AccountTakeoverEventActionType
    def getSendNotification
        : ZIO[Any, Nothing, AccountTakeoverActionNotifyType] =
      ZIO.succeed(sendNotification)
    def getEventAction: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.AccountTakeoverEventActionType
    ] = ZIO.succeed(eventAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverActionType
  ) extends zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType.ReadOnly {
    override val sendNotification: AccountTakeoverActionNotifyType =
      zio.aws.cognitoidentityprovider.model.primitives
        .AccountTakeoverActionNotifyType(impl.sendNotification())
    override val eventAction
        : zio.aws.cognitoidentityprovider.model.AccountTakeoverEventActionType =
      zio.aws.cognitoidentityprovider.model.AccountTakeoverEventActionType
        .wrap(impl.eventAction())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverActionType
  ): zio.aws.cognitoidentityprovider.model.AccountTakeoverActionType.ReadOnly =
    new Wrapper(impl)
}
