package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class StringAttributeConstraintsType(
    minLength: Optional[StringType] = Optional.Absent,
    maxLength: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.StringAttributeConstraintsType = {
    import StringAttributeConstraintsType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.StringAttributeConstraintsType
      .builder()
      .optionallyWith(minLength.map(value => value: java.lang.String))(
        _.minLength
      )
      .optionallyWith(maxLength.map(value => value: java.lang.String))(
        _.maxLength
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.StringAttributeConstraintsType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.StringAttributeConstraintsType
      .wrap(buildAwsValue())
}
object StringAttributeConstraintsType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.StringAttributeConstraintsType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.StringAttributeConstraintsType =
      zio.aws.cognitoidentityprovider.model.StringAttributeConstraintsType(
        minLength.map(value => value),
        maxLength.map(value => value)
      )
    def minLength: Optional[StringType]
    def maxLength: Optional[StringType]
    def getMinLength: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("minLength", minLength)
    def getMaxLength: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("maxLength", maxLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.StringAttributeConstraintsType
  ) extends zio.aws.cognitoidentityprovider.model.StringAttributeConstraintsType.ReadOnly {
    override val minLength: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.minLength())
      .map(value => value: StringType)
    override val maxLength: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxLength())
      .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.StringAttributeConstraintsType
  ): zio.aws.cognitoidentityprovider.model.StringAttributeConstraintsType.ReadOnly =
    new Wrapper(impl)
}
