package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  TemporaryPasswordValidityDaysType,
  BooleanType,
  PasswordPolicyMinLengthType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PasswordPolicyType(
    minimumLength: Optional[PasswordPolicyMinLengthType] = Optional.Absent,
    requireUppercase: Optional[BooleanType] = Optional.Absent,
    requireLowercase: Optional[BooleanType] = Optional.Absent,
    requireNumbers: Optional[BooleanType] = Optional.Absent,
    requireSymbols: Optional[BooleanType] = Optional.Absent,
    temporaryPasswordValidityDays: Optional[TemporaryPasswordValidityDaysType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordPolicyType = {
    import PasswordPolicyType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordPolicyType
      .builder()
      .optionallyWith(
        minimumLength.map(value =>
          PasswordPolicyMinLengthType.unwrap(value): Integer
        )
      )(_.minimumLength)
      .optionallyWith(
        requireUppercase.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireUppercase)
      .optionallyWith(
        requireLowercase.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireLowercase)
      .optionallyWith(
        requireNumbers.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireNumbers)
      .optionallyWith(
        requireSymbols.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireSymbols)
      .optionallyWith(
        temporaryPasswordValidityDays.map(value =>
          TemporaryPasswordValidityDaysType.unwrap(value): Integer
        )
      )(_.temporaryPasswordValidityDays)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.PasswordPolicyType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.PasswordPolicyType
      .wrap(buildAwsValue())
}
object PasswordPolicyType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordPolicyType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.PasswordPolicyType =
      zio.aws.cognitoidentityprovider.model.PasswordPolicyType(
        minimumLength.map(value => value),
        requireUppercase.map(value => value),
        requireLowercase.map(value => value),
        requireNumbers.map(value => value),
        requireSymbols.map(value => value),
        temporaryPasswordValidityDays.map(value => value)
      )
    def minimumLength: Optional[PasswordPolicyMinLengthType]
    def requireUppercase: Optional[BooleanType]
    def requireLowercase: Optional[BooleanType]
    def requireNumbers: Optional[BooleanType]
    def requireSymbols: Optional[BooleanType]
    def temporaryPasswordValidityDays
        : Optional[TemporaryPasswordValidityDaysType]
    def getMinimumLength: ZIO[Any, AwsError, PasswordPolicyMinLengthType] =
      AwsError.unwrapOptionField("minimumLength", minimumLength)
    def getRequireUppercase: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("requireUppercase", requireUppercase)
    def getRequireLowercase: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("requireLowercase", requireLowercase)
    def getRequireNumbers: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("requireNumbers", requireNumbers)
    def getRequireSymbols: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("requireSymbols", requireSymbols)
    def getTemporaryPasswordValidityDays
        : ZIO[Any, AwsError, TemporaryPasswordValidityDaysType] =
      AwsError.unwrapOptionField(
        "temporaryPasswordValidityDays",
        temporaryPasswordValidityDays
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordPolicyType
  ) extends zio.aws.cognitoidentityprovider.model.PasswordPolicyType.ReadOnly {
    override val minimumLength: Optional[PasswordPolicyMinLengthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumLength())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .PasswordPolicyMinLengthType(value)
        )
    override val requireUppercase: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.requireUppercase())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val requireLowercase: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.requireLowercase())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val requireNumbers: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.requireNumbers())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val requireSymbols: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.requireSymbols())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val temporaryPasswordValidityDays
        : Optional[TemporaryPasswordValidityDaysType] = zio.aws.core.internal
      .optionalFromNullable(impl.temporaryPasswordValidityDays())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .TemporaryPasswordValidityDaysType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordPolicyType
  ): zio.aws.cognitoidentityprovider.model.PasswordPolicyType.ReadOnly =
    new Wrapper(impl)
}
