package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.ArnType
import scala.jdk.CollectionConverters._
final case class CustomEmailLambdaVersionConfigType(
    lambdaVersion: zio.aws.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType,
    lambdaArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType = {
    import CustomEmailLambdaVersionConfigType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType
      .builder()
      .lambdaVersion(lambdaVersion.unwrap)
      .lambdaArn(ArnType.unwrap(lambdaArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType
      .wrap(buildAwsValue())
}
object CustomEmailLambdaVersionConfigType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType =
      zio.aws.cognitoidentityprovider.model
        .CustomEmailLambdaVersionConfigType(lambdaVersion, lambdaArn)
    def lambdaVersion
        : zio.aws.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType
    def lambdaArn: ArnType
    def getLambdaVersion: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType
    ] = ZIO.succeed(lambdaVersion)
    def getLambdaArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(lambdaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType
  ) extends zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType.ReadOnly {
    override val lambdaVersion
        : zio.aws.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType =
      zio.aws.cognitoidentityprovider.model.CustomEmailSenderLambdaVersionType
        .wrap(impl.lambdaVersion())
    override val lambdaArn: ArnType =
      zio.aws.cognitoidentityprovider.model.primitives.ArnType(impl.lambdaArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType
  ): zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType.ReadOnly =
    new Wrapper(impl)
}
