package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.DomainType
import scala.jdk.CollectionConverters._
final case class UpdateUserPoolDomainResponse(
    cloudFrontDomain: Optional[DomainType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse = {
    import UpdateUserPoolDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse
      .builder()
      .optionallyWith(
        cloudFrontDomain.map(value =>
          DomainType.unwrap(value): java.lang.String
        )
      )(_.cloudFrontDomain)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainResponse
      .wrap(buildAwsValue())
}
object UpdateUserPoolDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainResponse =
      zio.aws.cognitoidentityprovider.model
        .UpdateUserPoolDomainResponse(cloudFrontDomain.map(value => value))
    def cloudFrontDomain: Optional[DomainType]
    def getCloudFrontDomain: ZIO[Any, AwsError, DomainType] =
      AwsError.unwrapOptionField("cloudFrontDomain", cloudFrontDomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse
  ) extends zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainResponse.ReadOnly {
    override val cloudFrontDomain: Optional[DomainType] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudFrontDomain())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DomainType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse
  ): zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainResponse.ReadOnly =
    new Wrapper(impl)
}
