package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateUserAttributesResponse(
    codeDeliveryDetailsList: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse = {
    import UpdateUserAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse
      .builder()
      .optionallyWith(
        codeDeliveryDetailsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.codeDeliveryDetailsList)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UpdateUserAttributesResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UpdateUserAttributesResponse
      .wrap(buildAwsValue())
}
object UpdateUserAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UpdateUserAttributesResponse =
      zio.aws.cognitoidentityprovider.model.UpdateUserAttributesResponse(
        codeDeliveryDetailsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def codeDeliveryDetailsList: Optional[List[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ]]
    def getCodeDeliveryDetailsList: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "codeDeliveryDetailsList",
      codeDeliveryDetailsList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse
  ) extends zio.aws.cognitoidentityprovider.model.UpdateUserAttributesResponse.ReadOnly {
    override val codeDeliveryDetailsList: Optional[List[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.codeDeliveryDetailsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse
  ): zio.aws.cognitoidentityprovider.model.UpdateUserAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
