package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class DeviceSecretVerifierConfigType(
    passwordVerifier: Optional[StringType] = Optional.Absent,
    salt: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceSecretVerifierConfigType = {
    import DeviceSecretVerifierConfigType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceSecretVerifierConfigType
      .builder()
      .optionallyWith(passwordVerifier.map(value => value: java.lang.String))(
        _.passwordVerifier
      )
      .optionallyWith(salt.map(value => value: java.lang.String))(_.salt)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DeviceSecretVerifierConfigType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DeviceSecretVerifierConfigType
      .wrap(buildAwsValue())
}
object DeviceSecretVerifierConfigType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceSecretVerifierConfigType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DeviceSecretVerifierConfigType =
      zio.aws.cognitoidentityprovider.model.DeviceSecretVerifierConfigType(
        passwordVerifier.map(value => value),
        salt.map(value => value)
      )
    def passwordVerifier: Optional[StringType]
    def salt: Optional[StringType]
    def getPasswordVerifier: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("passwordVerifier", passwordVerifier)
    def getSalt: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("salt", salt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceSecretVerifierConfigType
  ) extends zio.aws.cognitoidentityprovider.model.DeviceSecretVerifierConfigType.ReadOnly {
    override val passwordVerifier: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.passwordVerifier())
      .map(value => value: StringType)
    override val salt: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.salt())
      .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceSecretVerifierConfigType
  ): zio.aws.cognitoidentityprovider.model.DeviceSecretVerifierConfigType.ReadOnly =
    new Wrapper(impl)
}
