package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateUserPoolClientResponse(
    userPoolClient: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolClientType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse = {
    import CreateUserPoolClientResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse
      .builder()
      .optionallyWith(userPoolClient.map(value => value.buildAwsValue()))(
        _.userPoolClient
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CreateUserPoolClientResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CreateUserPoolClientResponse
      .wrap(buildAwsValue())
}
object CreateUserPoolClientResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CreateUserPoolClientResponse =
      zio.aws.cognitoidentityprovider.model.CreateUserPoolClientResponse(
        userPoolClient.map(value => value.asEditable)
      )
    def userPoolClient: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolClientType.ReadOnly
    ]
    def getUserPoolClient: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolClientType.ReadOnly
    ] = AwsError.unwrapOptionField("userPoolClient", userPoolClient)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse
  ) extends zio.aws.cognitoidentityprovider.model.CreateUserPoolClientResponse.ReadOnly {
    override val userPoolClient: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolClientType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolClient())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolClientType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse
  ): zio.aws.cognitoidentityprovider.model.CreateUserPoolClientResponse.ReadOnly =
    new Wrapper(impl)
}
