package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  PasswordType,
  SecretHashType,
  UsernameType,
  ClientIdType,
  StringType
}
import scala.jdk.CollectionConverters._
final case class SignUpRequest(
    clientId: ClientIdType,
    secretHash: Option[SecretHashType] = None,
    username: UsernameType,
    password: PasswordType,
    userAttributes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.AttributeType]
    ] = None,
    validationData: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.AttributeType]
    ] = None,
    analyticsMetadata: Option[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType
    ] = None,
    userContextData: Option[
      zio.aws.cognitoidentityprovider.model.UserContextDataType
    ] = None,
    clientMetadata: Option[Map[StringType, StringType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest = {
    import SignUpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest
      .builder()
      .clientId(ClientIdType.unwrap(clientId): java.lang.String)
      .optionallyWith(
        secretHash.map(value => SecretHashType.unwrap(value): java.lang.String)
      )(_.secretHash)
      .username(UsernameType.unwrap(username): java.lang.String)
      .password(PasswordType.unwrap(password): java.lang.String)
      .optionallyWith(
        userAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAttributes)
      .optionallyWith(
        validationData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationData)
      .optionallyWith(analyticsMetadata.map(value => value.buildAwsValue()))(
        _.analyticsMetadata
      )
      .optionallyWith(userContextData.map(value => value.buildAwsValue()))(
        _.userContextData
      )
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.SignUpRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SignUpRequest.wrap(buildAwsValue())
}
object SignUpRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.SignUpRequest =
      zio.aws.cognitoidentityprovider.model.SignUpRequest(
        clientId,
        secretHash.map(value => value),
        username,
        password,
        userAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        validationData.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        analyticsMetadata.map(value => value.asEditable),
        userContextData.map(value => value.asEditable),
        clientMetadata.map(value => value)
      )
    def clientId: ClientIdType
    def secretHash: Option[SecretHashType]
    def username: UsernameType
    def password: PasswordType
    def userAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ]
    def validationData: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ]
    def analyticsMetadata: Option[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ]
    def userContextData: Option[
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ]
    def clientMetadata: Option[Map[StringType, StringType]]
    def getClientId: ZIO[Any, Nothing, ClientIdType] = ZIO.succeed(clientId)
    def getSecretHash: ZIO[Any, AwsError, SecretHashType] =
      AwsError.unwrapOptionField("secretHash", secretHash)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getPassword: ZIO[Any, Nothing, PasswordType] = ZIO.succeed(password)
    def getUserAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly
    ]] = AwsError.unwrapOptionField("userAttributes", userAttributes)
    def getValidationData: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly
    ]] = AwsError.unwrapOptionField("validationData", validationData)
    def getAnalyticsMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = AwsError.unwrapOptionField("analyticsMetadata", analyticsMetadata)
    def getUserContextData: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ] = AwsError.unwrapOptionField("userContextData", userContextData)
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest
  ) extends zio.aws.cognitoidentityprovider.model.SignUpRequest.ReadOnly {
    override val clientId: ClientIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ClientIdType(impl.clientId())
    override val secretHash: Option[SecretHashType] = scala
      .Option(impl.secretHash())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SecretHashType(value)
      )
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val password: PasswordType =
      zio.aws.cognitoidentityprovider.model.primitives
        .PasswordType(impl.password())
    override val userAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ] = scala
      .Option(impl.userAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AttributeType.wrap(item)
        }.toList
      )
    override val validationData: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ] = scala
      .Option(impl.validationData())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AttributeType.wrap(item)
        }.toList
      )
    override val analyticsMetadata: Option[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = scala
      .Option(impl.analyticsMetadata())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.wrap(value)
      )
    override val userContextData: Option[
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ] = scala
      .Option(impl.userContextData())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserContextDataType.wrap(value)
      )
    override val clientMetadata: Option[Map[StringType, StringType]] = scala
      .Option(impl.clientMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: StringType) -> (value: StringType)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest
  ): zio.aws.cognitoidentityprovider.model.SignUpRequest.ReadOnly = new Wrapper(
    impl
  )
}
