package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  BooleanType,
  CustomAttributeNameType
}
import scala.jdk.CollectionConverters._
final case class SchemaAttributeType(
    name: Option[CustomAttributeNameType] = None,
    attributeDataType: Option[
      zio.aws.cognitoidentityprovider.model.AttributeDataType
    ] = None,
    developerOnlyAttribute: Option[BooleanType] = None,
    mutable: Option[BooleanType] = None,
    required: Option[BooleanType] = None,
    numberAttributeConstraints: Option[
      zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType
    ] = None,
    stringAttributeConstraints: Option[
      zio.aws.cognitoidentityprovider.model.StringAttributeConstraintsType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType = {
    import SchemaAttributeType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType
      .builder()
      .optionallyWith(
        name.map(value =>
          CustomAttributeNameType.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(attributeDataType.map(value => value.unwrap))(
        _.attributeDataType
      )
      .optionallyWith(
        developerOnlyAttribute.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.developerOnlyAttribute)
      .optionallyWith(
        mutable.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.mutable)
      .optionallyWith(
        required.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.required)
      .optionallyWith(
        numberAttributeConstraints.map(value => value.buildAwsValue())
      )(_.numberAttributeConstraints)
      .optionallyWith(
        stringAttributeConstraints.map(value => value.buildAwsValue())
      )(_.stringAttributeConstraints)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SchemaAttributeType
      .wrap(buildAwsValue())
}
object SchemaAttributeType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.SchemaAttributeType =
      zio.aws.cognitoidentityprovider.model.SchemaAttributeType(
        name.map(value => value),
        attributeDataType.map(value => value),
        developerOnlyAttribute.map(value => value),
        mutable.map(value => value),
        required.map(value => value),
        numberAttributeConstraints.map(value => value.asEditable),
        stringAttributeConstraints.map(value => value.asEditable)
      )
    def name: Option[CustomAttributeNameType]
    def attributeDataType
        : Option[zio.aws.cognitoidentityprovider.model.AttributeDataType]
    def developerOnlyAttribute: Option[BooleanType]
    def mutable: Option[BooleanType]
    def required: Option[BooleanType]
    def numberAttributeConstraints: Option[
      zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType.ReadOnly
    ]
    def stringAttributeConstraints: Option[
      zio.aws.cognitoidentityprovider.model.StringAttributeConstraintsType.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, CustomAttributeNameType] =
      AwsError.unwrapOptionField("name", name)
    def getAttributeDataType: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AttributeDataType
    ] = AwsError.unwrapOptionField("attributeDataType", attributeDataType)
    def getDeveloperOnlyAttribute: ZIO[Any, AwsError, BooleanType] = AwsError
      .unwrapOptionField("developerOnlyAttribute", developerOnlyAttribute)
    def getMutable: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("mutable", mutable)
    def getRequired: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("required", required)
    def getNumberAttributeConstraints: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "numberAttributeConstraints",
      numberAttributeConstraints
    )
    def getStringAttributeConstraints: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.StringAttributeConstraintsType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "stringAttributeConstraints",
      stringAttributeConstraints
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType
  ) extends zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly {
    override val name: Option[CustomAttributeNameType] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .CustomAttributeNameType(value)
      )
    override val attributeDataType
        : Option[zio.aws.cognitoidentityprovider.model.AttributeDataType] =
      scala
        .Option(impl.attributeDataType())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.AttributeDataType.wrap(value)
        )
    override val developerOnlyAttribute: Option[BooleanType] = scala
      .Option(impl.developerOnlyAttribute())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val mutable: Option[BooleanType] = scala
      .Option(impl.mutable())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val required: Option[BooleanType] = scala
      .Option(impl.required())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val numberAttributeConstraints: Option[
      zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType.ReadOnly
    ] = scala
      .Option(impl.numberAttributeConstraints())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType
          .wrap(value)
      )
    override val stringAttributeConstraints: Option[
      zio.aws.cognitoidentityprovider.model.StringAttributeConstraintsType.ReadOnly
    ] = scala
      .Option(impl.stringAttributeConstraints())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.StringAttributeConstraintsType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType
  ): zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly =
    new Wrapper(impl)
}
