package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.ArnType
import scala.jdk.CollectionConverters._
final case class LambdaConfigType(
    preSignUp: Option[ArnType] = None,
    customMessage: Option[ArnType] = None,
    postConfirmation: Option[ArnType] = None,
    preAuthentication: Option[ArnType] = None,
    postAuthentication: Option[ArnType] = None,
    defineAuthChallenge: Option[ArnType] = None,
    createAuthChallenge: Option[ArnType] = None,
    verifyAuthChallengeResponse: Option[ArnType] = None,
    preTokenGeneration: Option[ArnType] = None,
    userMigration: Option[ArnType] = None,
    customSMSSender: Option[
      zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType
    ] = None,
    customEmailSender: Option[
      zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType
    ] = None,
    kmsKeyID: Option[ArnType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType = {
    import LambdaConfigType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType
      .builder()
      .optionallyWith(
        preSignUp.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.preSignUp)
      .optionallyWith(
        customMessage.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.customMessage)
      .optionallyWith(
        postConfirmation.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.postConfirmation)
      .optionallyWith(
        preAuthentication.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.preAuthentication)
      .optionallyWith(
        postAuthentication.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.postAuthentication)
      .optionallyWith(
        defineAuthChallenge.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.defineAuthChallenge)
      .optionallyWith(
        createAuthChallenge.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.createAuthChallenge)
      .optionallyWith(
        verifyAuthChallengeResponse.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.verifyAuthChallengeResponse)
      .optionallyWith(
        preTokenGeneration.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.preTokenGeneration)
      .optionallyWith(
        userMigration.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.userMigration)
      .optionallyWith(customSMSSender.map(value => value.buildAwsValue()))(
        _.customSMSSender
      )
      .optionallyWith(customEmailSender.map(value => value.buildAwsValue()))(
        _.customEmailSender
      )
      .optionallyWith(
        kmsKeyID.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.kmsKeyID)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.LambdaConfigType.wrap(buildAwsValue())
}
object LambdaConfigType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.LambdaConfigType =
      zio.aws.cognitoidentityprovider.model.LambdaConfigType(
        preSignUp.map(value => value),
        customMessage.map(value => value),
        postConfirmation.map(value => value),
        preAuthentication.map(value => value),
        postAuthentication.map(value => value),
        defineAuthChallenge.map(value => value),
        createAuthChallenge.map(value => value),
        verifyAuthChallengeResponse.map(value => value),
        preTokenGeneration.map(value => value),
        userMigration.map(value => value),
        customSMSSender.map(value => value.asEditable),
        customEmailSender.map(value => value.asEditable),
        kmsKeyID.map(value => value)
      )
    def preSignUp: Option[ArnType]
    def customMessage: Option[ArnType]
    def postConfirmation: Option[ArnType]
    def preAuthentication: Option[ArnType]
    def postAuthentication: Option[ArnType]
    def defineAuthChallenge: Option[ArnType]
    def createAuthChallenge: Option[ArnType]
    def verifyAuthChallengeResponse: Option[ArnType]
    def preTokenGeneration: Option[ArnType]
    def userMigration: Option[ArnType]
    def customSMSSender: Option[
      zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType.ReadOnly
    ]
    def customEmailSender: Option[
      zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType.ReadOnly
    ]
    def kmsKeyID: Option[ArnType]
    def getPreSignUp: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("preSignUp", preSignUp)
    def getCustomMessage: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("customMessage", customMessage)
    def getPostConfirmation: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("postConfirmation", postConfirmation)
    def getPreAuthentication: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("preAuthentication", preAuthentication)
    def getPostAuthentication: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("postAuthentication", postAuthentication)
    def getDefineAuthChallenge: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("defineAuthChallenge", defineAuthChallenge)
    def getCreateAuthChallenge: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("createAuthChallenge", createAuthChallenge)
    def getVerifyAuthChallengeResponse: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField(
        "verifyAuthChallengeResponse",
        verifyAuthChallengeResponse
      )
    def getPreTokenGeneration: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("preTokenGeneration", preTokenGeneration)
    def getUserMigration: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("userMigration", userMigration)
    def getCustomSMSSender: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("customSMSSender", customSMSSender)
    def getCustomEmailSender: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("customEmailSender", customEmailSender)
    def getKmsKeyID: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("kmsKeyID", kmsKeyID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType
  ) extends zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly {
    override val preSignUp: Option[ArnType] = scala
      .Option(impl.preSignUp())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val customMessage: Option[ArnType] = scala
      .Option(impl.customMessage())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val postConfirmation: Option[ArnType] = scala
      .Option(impl.postConfirmation())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val preAuthentication: Option[ArnType] = scala
      .Option(impl.preAuthentication())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val postAuthentication: Option[ArnType] = scala
      .Option(impl.postAuthentication())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val defineAuthChallenge: Option[ArnType] = scala
      .Option(impl.defineAuthChallenge())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val createAuthChallenge: Option[ArnType] = scala
      .Option(impl.createAuthChallenge())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val verifyAuthChallengeResponse: Option[ArnType] = scala
      .Option(impl.verifyAuthChallengeResponse())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val preTokenGeneration: Option[ArnType] = scala
      .Option(impl.preTokenGeneration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val userMigration: Option[ArnType] = scala
      .Option(impl.userMigration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val customSMSSender: Option[
      zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType.ReadOnly
    ] = scala
      .Option(impl.customSMSSender())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType
          .wrap(value)
      )
    override val customEmailSender: Option[
      zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType.ReadOnly
    ] = scala
      .Option(impl.customEmailSender())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CustomEmailLambdaVersionConfigType
          .wrap(value)
      )
    override val kmsKeyID: Option[ArnType] = scala
      .Option(impl.kmsKeyID())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType
  ): zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly =
    new Wrapper(impl)
}
