package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait DomainStatusType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType
}
object DomainStatusType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType
  ): zio.aws.cognitoidentityprovider.model.DomainStatusType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.DomainStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING
      extends zio.aws.cognitoidentityprovider.model.DomainStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType.CREATING
  }
  case object DELETING
      extends zio.aws.cognitoidentityprovider.model.DomainStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType.DELETING
  }
  case object UPDATING
      extends zio.aws.cognitoidentityprovider.model.DomainStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType.UPDATING
  }
  case object ACTIVE
      extends zio.aws.cognitoidentityprovider.model.DomainStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType.ACTIVE
  }
  case object FAILED
      extends zio.aws.cognitoidentityprovider.model.DomainStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType.FAILED
  }
}
