package zio.aws.cognitoidentityprovider.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  IntegerType,
  TokenModelType
}
import scala.jdk.CollectionConverters._
final case class AuthenticationResultType(
    accessToken: Option[TokenModelType] = None,
    expiresIn: Option[IntegerType] = None,
    tokenType: Option[StringType] = None,
    refreshToken: Option[TokenModelType] = None,
    idToken: Option[TokenModelType] = None,
    newDeviceMetadata: Option[
      zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType = {
    import AuthenticationResultType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType
      .builder()
      .optionallyWith(
        accessToken.map(value => TokenModelType.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(
        expiresIn.map(value => IntegerType.unwrap(value): Integer)
      )(_.expiresIn)
      .optionallyWith(tokenType.map(value => value: java.lang.String))(
        _.tokenType
      )
      .optionallyWith(
        refreshToken.map(value =>
          TokenModelType.unwrap(value): java.lang.String
        )
      )(_.refreshToken)
      .optionallyWith(
        idToken.map(value => TokenModelType.unwrap(value): java.lang.String)
      )(_.idToken)
      .optionallyWith(newDeviceMetadata.map(value => value.buildAwsValue()))(
        _.newDeviceMetadata
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AuthenticationResultType
      .wrap(buildAwsValue())
}
object AuthenticationResultType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AuthenticationResultType =
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType(
        accessToken.map(value => value),
        expiresIn.map(value => value),
        tokenType.map(value => value),
        refreshToken.map(value => value),
        idToken.map(value => value),
        newDeviceMetadata.map(value => value.asEditable)
      )
    def accessToken: Option[TokenModelType]
    def expiresIn: Option[IntegerType]
    def tokenType: Option[StringType]
    def refreshToken: Option[TokenModelType]
    def idToken: Option[TokenModelType]
    def newDeviceMetadata: Option[
      zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType.ReadOnly
    ]
    def getAccessToken: ZIO[Any, AwsError, TokenModelType] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getExpiresIn: ZIO[Any, AwsError, IntegerType] =
      AwsError.unwrapOptionField("expiresIn", expiresIn)
    def getTokenType: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("tokenType", tokenType)
    def getRefreshToken: ZIO[Any, AwsError, TokenModelType] =
      AwsError.unwrapOptionField("refreshToken", refreshToken)
    def getIdToken: ZIO[Any, AwsError, TokenModelType] =
      AwsError.unwrapOptionField("idToken", idToken)
    def getNewDeviceMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType.ReadOnly
    ] = AwsError.unwrapOptionField("newDeviceMetadata", newDeviceMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType
  ) extends zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly {
    override val accessToken: Option[TokenModelType] = scala
      .Option(impl.accessToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.TokenModelType(value)
      )
    override val expiresIn: Option[IntegerType] = scala
      .Option(impl.expiresIn())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.IntegerType(value)
      )
    override val tokenType: Option[StringType] =
      scala.Option(impl.tokenType()).map(value => value: StringType)
    override val refreshToken: Option[TokenModelType] = scala
      .Option(impl.refreshToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.TokenModelType(value)
      )
    override val idToken: Option[TokenModelType] = scala
      .Option(impl.idToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.TokenModelType(value)
      )
    override val newDeviceMetadata: Option[
      zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType.ReadOnly
    ] = scala
      .Option(impl.newDeviceMetadata())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType
  ): zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly =
    new Wrapper(impl)
}
