package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminUpdateUserAttributesRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    userAttributes: Iterable[
      zio.aws.cognitoidentityprovider.model.AttributeType
    ],
    clientMetadata: Option[Map[StringType, StringType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest = {
    import AdminUpdateUserAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .userAttributes(userAttributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest
      .wrap(buildAwsValue())
}
object AdminUpdateUserAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest =
      zio.aws.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest(
        userPoolId,
        username,
        userAttributes.map { item =>
          item.asEditable
        },
        clientMetadata.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def userAttributes
        : List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    def clientMetadata: Option[Map[StringType, StringType]]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getUserAttributes: ZIO[Any, Nothing, List[
      zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly
    ]] = ZIO.succeed(userAttributes)
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val userAttributes
        : List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly] =
      impl
        .userAttributes()
        .asScala
        .map { item =>
          zio.aws.cognitoidentityprovider.model.AttributeType.wrap(item)
        }
        .toList
    override val clientMetadata: Option[Map[StringType, StringType]] = scala
      .Option(impl.clientMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: StringType) -> (value: StringType)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest
  ): zio.aws.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
