package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class ContextDataType(
    ipAddress: StringType,
    serverName: StringType,
    serverPath: StringType,
    httpHeaders: Iterable[zio.aws.cognitoidentityprovider.model.HttpHeader],
    encodedData: Option[StringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ContextDataType = {
    import ContextDataType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ContextDataType
      .builder()
      .ipAddress(ipAddress: java.lang.String)
      .serverName(serverName: java.lang.String)
      .serverPath(serverPath: java.lang.String)
      .httpHeaders(httpHeaders.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(encodedData.map(value => value: java.lang.String))(
        _.encodedData
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ContextDataType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ContextDataType.wrap(buildAwsValue())
}
object ContextDataType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ContextDataType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.ContextDataType =
      zio.aws.cognitoidentityprovider.model.ContextDataType(
        ipAddress,
        serverName,
        serverPath,
        httpHeaders.map { item =>
          item.asEditable
        },
        encodedData.map(value => value)
      )
    def ipAddress: StringType
    def serverName: StringType
    def serverPath: StringType
    def httpHeaders
        : List[zio.aws.cognitoidentityprovider.model.HttpHeader.ReadOnly]
    def encodedData: Option[StringType]
    def getIpAddress: ZIO[Any, Nothing, StringType] = ZIO.succeed(ipAddress)
    def getServerName: ZIO[Any, Nothing, StringType] = ZIO.succeed(serverName)
    def getServerPath: ZIO[Any, Nothing, StringType] = ZIO.succeed(serverPath)
    def getHttpHeaders: ZIO[Any, Nothing, List[
      zio.aws.cognitoidentityprovider.model.HttpHeader.ReadOnly
    ]] = ZIO.succeed(httpHeaders)
    def getEncodedData: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("encodedData", encodedData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ContextDataType
  ) extends zio.aws.cognitoidentityprovider.model.ContextDataType.ReadOnly {
    override val ipAddress: StringType = impl.ipAddress(): StringType
    override val serverName: StringType = impl.serverName(): StringType
    override val serverPath: StringType = impl.serverPath(): StringType
    override val httpHeaders
        : List[zio.aws.cognitoidentityprovider.model.HttpHeader.ReadOnly] = impl
      .httpHeaders()
      .asScala
      .map { item =>
        zio.aws.cognitoidentityprovider.model.HttpHeader.wrap(item)
      }
      .toList
    override val encodedData: Option[StringType] =
      scala.Option(impl.encodedData()).map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ContextDataType
  ): zio.aws.cognitoidentityprovider.model.ContextDataType.ReadOnly =
    new Wrapper(impl)
}
