package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  BooleanType,
  DateType,
  UsernameType
}
import scala.jdk.CollectionConverters._
final case class AdminGetUserResponse(
    username: UsernameType,
    userAttributes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.AttributeType]
    ] = None,
    userCreateDate: Option[DateType] = None,
    userLastModifiedDate: Option[DateType] = None,
    enabled: Option[BooleanType] = None,
    userStatus: Option[zio.aws.cognitoidentityprovider.model.UserStatusType] =
      None,
    mfaOptions: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.MFAOptionType]
    ] = None,
    preferredMfaSetting: Option[StringType] = None,
    userMFASettingList: Option[Iterable[StringType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse = {
    import AdminGetUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse
      .builder()
      .username(UsernameType.unwrap(username): java.lang.String)
      .optionallyWith(
        userAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAttributes)
      .optionallyWith(
        userCreateDate.map(value => DateType.unwrap(value): Instant)
      )(_.userCreateDate)
      .optionallyWith(
        userLastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.userLastModifiedDate)
      .optionallyWith(
        enabled.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(userStatus.map(value => value.unwrap))(_.userStatus)
      .optionallyWith(
        mfaOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mfaOptions)
      .optionallyWith(
        preferredMfaSetting.map(value => value: java.lang.String)
      )(_.preferredMfaSetting)
      .optionallyWith(
        userMFASettingList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userMFASettingList)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminGetUserResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminGetUserResponse
      .wrap(buildAwsValue())
}
object AdminGetUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.AdminGetUserResponse =
      zio.aws.cognitoidentityprovider.model.AdminGetUserResponse(
        username,
        userAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userCreateDate.map(value => value),
        userLastModifiedDate.map(value => value),
        enabled.map(value => value),
        userStatus.map(value => value),
        mfaOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        preferredMfaSetting.map(value => value),
        userMFASettingList.map(value => value)
      )
    def username: UsernameType
    def userAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ]
    def userCreateDate: Option[DateType]
    def userLastModifiedDate: Option[DateType]
    def enabled: Option[BooleanType]
    def userStatus: Option[zio.aws.cognitoidentityprovider.model.UserStatusType]
    def mfaOptions: Option[
      List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly]
    ]
    def preferredMfaSetting: Option[StringType]
    def userMFASettingList: Option[List[StringType]]
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getUserAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly
    ]] = AwsError.unwrapOptionField("userAttributes", userAttributes)
    def getUserCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("userCreateDate", userCreateDate)
    def getUserLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("userLastModifiedDate", userLastModifiedDate)
    def getEnabled: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getUserStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserStatusType
    ] = AwsError.unwrapOptionField("userStatus", userStatus)
    def getMfaOptions: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly
    ]] = AwsError.unwrapOptionField("mfaOptions", mfaOptions)
    def getPreferredMfaSetting: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("preferredMfaSetting", preferredMfaSetting)
    def getUserMFASettingList: ZIO[Any, AwsError, List[StringType]] =
      AwsError.unwrapOptionField("userMFASettingList", userMFASettingList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse
  ) extends zio.aws.cognitoidentityprovider.model.AdminGetUserResponse.ReadOnly {
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val userAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ] = scala
      .Option(impl.userAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AttributeType.wrap(item)
        }.toList
      )
    override val userCreateDate: Option[DateType] = scala
      .Option(impl.userCreateDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val userLastModifiedDate: Option[DateType] = scala
      .Option(impl.userLastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val enabled: Option[BooleanType] = scala
      .Option(impl.enabled())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val userStatus
        : Option[zio.aws.cognitoidentityprovider.model.UserStatusType] = scala
      .Option(impl.userStatus())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserStatusType.wrap(value)
      )
    override val mfaOptions: Option[
      List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly]
    ] = scala
      .Option(impl.mfaOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.MFAOptionType.wrap(item)
        }.toList
      )
    override val preferredMfaSetting: Option[StringType] =
      scala.Option(impl.preferredMfaSetting()).map(value => value: StringType)
    override val userMFASettingList: Option[List[StringType]] = scala
      .Option(impl.userMFASettingList())
      .map(value =>
        value.asScala.map { item =>
          item: StringType
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse
  ): zio.aws.cognitoidentityprovider.model.AdminGetUserResponse.ReadOnly =
    new Wrapper(impl)
}
