package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TokenValidityUnitsType(
    accessToken: Option[zio.aws.cognitoidentityprovider.model.TimeUnitsType] =
      None,
    idToken: Option[zio.aws.cognitoidentityprovider.model.TimeUnitsType] = None,
    refreshToken: Option[zio.aws.cognitoidentityprovider.model.TimeUnitsType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.TokenValidityUnitsType = {
    import TokenValidityUnitsType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.TokenValidityUnitsType
      .builder()
      .optionallyWith(accessToken.map(value => value.unwrap))(_.accessToken)
      .optionallyWith(idToken.map(value => value.unwrap))(_.idToken)
      .optionallyWith(refreshToken.map(value => value.unwrap))(_.refreshToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.TokenValidityUnitsType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.TokenValidityUnitsType
      .wrap(buildAwsValue())
}
object TokenValidityUnitsType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.TokenValidityUnitsType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.TokenValidityUnitsType =
      zio.aws.cognitoidentityprovider.model.TokenValidityUnitsType(
        accessToken.map(value => value),
        idToken.map(value => value),
        refreshToken.map(value => value)
      )
    def accessToken: Option[zio.aws.cognitoidentityprovider.model.TimeUnitsType]
    def idToken: Option[zio.aws.cognitoidentityprovider.model.TimeUnitsType]
    def refreshToken
        : Option[zio.aws.cognitoidentityprovider.model.TimeUnitsType]
    def getAccessToken: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.TimeUnitsType
    ] = AwsError.unwrapOptionField("accessToken", accessToken)
    def getIdToken: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.TimeUnitsType
    ] = AwsError.unwrapOptionField("idToken", idToken)
    def getRefreshToken: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.TimeUnitsType
    ] = AwsError.unwrapOptionField("refreshToken", refreshToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.TokenValidityUnitsType
  ) extends zio.aws.cognitoidentityprovider.model.TokenValidityUnitsType.ReadOnly {
    override val accessToken
        : Option[zio.aws.cognitoidentityprovider.model.TimeUnitsType] = scala
      .Option(impl.accessToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.TimeUnitsType.wrap(value)
      )
    override val idToken
        : Option[zio.aws.cognitoidentityprovider.model.TimeUnitsType] = scala
      .Option(impl.idToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.TimeUnitsType.wrap(value)
      )
    override val refreshToken
        : Option[zio.aws.cognitoidentityprovider.model.TimeUnitsType] = scala
      .Option(impl.refreshToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.TimeUnitsType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.TokenValidityUnitsType
  ): zio.aws.cognitoidentityprovider.model.TokenValidityUnitsType.ReadOnly =
    new Wrapper(impl)
}
