package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.PaginationKey
import scala.jdk.CollectionConverters._
final case class ListUserPoolClientsResponse(
    userPoolClients: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.UserPoolClientDescription]
    ] = None,
    nextToken: Option[PaginationKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse = {
    import ListUserPoolClientsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse
      .builder()
      .optionallyWith(
        userPoolClients.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userPoolClients)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUserPoolClientsResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUserPoolClientsResponse
      .wrap(buildAwsValue())
}
object ListUserPoolClientsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListUserPoolClientsResponse =
      zio.aws.cognitoidentityprovider.model.ListUserPoolClientsResponse(
        userPoolClients.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def userPoolClients: Option[List[
      zio.aws.cognitoidentityprovider.model.UserPoolClientDescription.ReadOnly
    ]]
    def nextToken: Option[PaginationKey]
    def getUserPoolClients: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.UserPoolClientDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("userPoolClients", userPoolClients)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse
  ) extends zio.aws.cognitoidentityprovider.model.ListUserPoolClientsResponse.ReadOnly {
    override val userPoolClients: Option[List[
      zio.aws.cognitoidentityprovider.model.UserPoolClientDescription.ReadOnly
    ]] = scala
      .Option(impl.userPoolClients())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.UserPoolClientDescription
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationKey] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse
  ): zio.aws.cognitoidentityprovider.model.ListUserPoolClientsResponse.ReadOnly =
    new Wrapper(impl)
}
