package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.cognitoidentityprovider.model.primitives.{
  DateType,
  UserPoolNameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class UserPoolDescriptionType(
    id: Option[UserPoolIdType] = None,
    name: Option[UserPoolNameType] = None,
    lambdaConfig: Option[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType
    ] = None,
    status: Option[zio.aws.cognitoidentityprovider.model.StatusType] = None,
    lastModifiedDate: Option[DateType] = None,
    creationDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType = {
    import UserPoolDescriptionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType
      .builder()
      .optionallyWith(
        id.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => UserPoolNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(lambdaConfig.map(value => value.buildAwsValue()))(
        _.lambdaConfig
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType
      .wrap(buildAwsValue())
}
object UserPoolDescriptionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType =
      zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType(
        id.map(value => value),
        name.map(value => value),
        lambdaConfig.map(value => value.asEditable),
        status.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value)
      )
    def id: Option[UserPoolIdType]
    def name: Option[UserPoolNameType]
    def lambdaConfig: Option[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ]
    def status: Option[zio.aws.cognitoidentityprovider.model.StatusType]
    def lastModifiedDate: Option[DateType]
    def creationDate: Option[DateType]
    def getId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, UserPoolNameType] =
      AwsError.unwrapOptionField("name", name)
    def getLambdaConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaConfig", lambdaConfig)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cognitoidentityprovider.model.StatusType] =
      AwsError.unwrapOptionField("status", status)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType
  ) extends zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly {
    override val id: Option[UserPoolIdType] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val name: Option[UserPoolNameType] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolNameType(value)
      )
    override val lambdaConfig: Option[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ] = scala
      .Option(impl.lambdaConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.LambdaConfigType.wrap(value)
      )
    override val status
        : Option[zio.aws.cognitoidentityprovider.model.StatusType] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.StatusType.wrap(value)
      )
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType
  ): zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly =
    new Wrapper(impl)
}
