package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  ClientNameType,
  UserPoolIdType,
  ClientIdType
}
import scala.jdk.CollectionConverters._
final case class UserPoolClientDescription(
    clientId: Option[ClientIdType] = None,
    userPoolId: Option[UserPoolIdType] = None,
    clientName: Option[ClientNameType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientDescription = {
    import UserPoolClientDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientDescription
      .builder()
      .optionallyWith(
        clientId.map(value => ClientIdType.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        clientName.map(value => ClientNameType.unwrap(value): java.lang.String)
      )(_.clientName)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UserPoolClientDescription.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserPoolClientDescription
      .wrap(buildAwsValue())
}
object UserPoolClientDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UserPoolClientDescription =
      zio.aws.cognitoidentityprovider.model.UserPoolClientDescription(
        clientId.map(value => value),
        userPoolId.map(value => value),
        clientName.map(value => value)
      )
    def clientId: Option[ClientIdType]
    def userPoolId: Option[UserPoolIdType]
    def clientName: Option[ClientNameType]
    def getClientId: ZIO[Any, AwsError, ClientIdType] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getClientName: ZIO[Any, AwsError, ClientNameType] =
      AwsError.unwrapOptionField("clientName", clientName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientDescription
  ) extends zio.aws.cognitoidentityprovider.model.UserPoolClientDescription.ReadOnly {
    override val clientId: Option[ClientIdType] = scala
      .Option(impl.clientId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ClientIdType(value)
      )
    override val userPoolId: Option[UserPoolIdType] = scala
      .Option(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val clientName: Option[ClientNameType] = scala
      .Option(impl.clientName())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ClientNameType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientDescription
  ): zio.aws.cognitoidentityprovider.model.UserPoolClientDescription.ReadOnly =
    new Wrapper(impl)
}
