package zio.aws.cognitoidentityprovider.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  AttributeNameType,
  UserPoolIdType,
  UserFilterType,
  QueryLimitType,
  SearchPaginationTokenType
}
import scala.jdk.CollectionConverters._
final case class ListUsersRequest(
    userPoolId: UserPoolIdType,
    attributesToGet: Option[Iterable[AttributeNameType]] = None,
    limit: Option[QueryLimitType] = None,
    paginationToken: Option[SearchPaginationTokenType] = None,
    filter: Option[UserFilterType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest = {
    import ListUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(
        attributesToGet.map(value =>
          value.map { item =>
            AttributeNameType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attributesToGet)
      .optionallyWith(
        limit.map(value => QueryLimitType.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        paginationToken.map(value =>
          SearchPaginationTokenType.unwrap(value): java.lang.String
        )
      )(_.paginationToken)
      .optionallyWith(
        filter.map(value => UserFilterType.unwrap(value): java.lang.String)
      )(_.filter)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUsersRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUsersRequest.wrap(buildAwsValue())
}
object ListUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.ListUsersRequest =
      zio.aws.cognitoidentityprovider.model.ListUsersRequest(
        userPoolId,
        attributesToGet.map(value => value),
        limit.map(value => value),
        paginationToken.map(value => value),
        filter.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def attributesToGet: Option[List[AttributeNameType]]
    def limit: Option[QueryLimitType]
    def paginationToken: Option[SearchPaginationTokenType]
    def filter: Option[UserFilterType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getAttributesToGet: ZIO[Any, AwsError, List[AttributeNameType]] =
      AwsError.unwrapOptionField("attributesToGet", attributesToGet)
    def getLimit: ZIO[Any, AwsError, QueryLimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getPaginationToken: ZIO[Any, AwsError, SearchPaginationTokenType] =
      AwsError.unwrapOptionField("paginationToken", paginationToken)
    def getFilter: ZIO[Any, AwsError, UserFilterType] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest
  ) extends zio.aws.cognitoidentityprovider.model.ListUsersRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val attributesToGet: Option[List[AttributeNameType]] = scala
      .Option(impl.attributesToGet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.primitives
            .AttributeNameType(item)
        }.toList
      )
    override val limit: Option[QueryLimitType] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.QueryLimitType(value)
      )
    override val paginationToken: Option[SearchPaginationTokenType] = scala
      .Option(impl.paginationToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .SearchPaginationTokenType(value)
      )
    override val filter: Option[UserFilterType] = scala
      .Option(impl.filter())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserFilterType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest
  ): zio.aws.cognitoidentityprovider.model.ListUsersRequest.ReadOnly =
    new Wrapper(impl)
}
