package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.WrappedBooleanType
import scala.jdk.CollectionConverters._
final case class EventRiskType(
    riskDecision: Option[
      zio.aws.cognitoidentityprovider.model.RiskDecisionType
    ] = None,
    riskLevel: Option[zio.aws.cognitoidentityprovider.model.RiskLevelType] =
      None,
    compromisedCredentialsDetected: Option[WrappedBooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.EventRiskType = {
    import EventRiskType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.EventRiskType
      .builder()
      .optionallyWith(riskDecision.map(value => value.unwrap))(_.riskDecision)
      .optionallyWith(riskLevel.map(value => value.unwrap))(_.riskLevel)
      .optionallyWith(
        compromisedCredentialsDetected.map(value =>
          WrappedBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.compromisedCredentialsDetected)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.EventRiskType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.EventRiskType.wrap(buildAwsValue())
}
object EventRiskType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.EventRiskType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.EventRiskType =
      zio.aws.cognitoidentityprovider.model.EventRiskType(
        riskDecision.map(value => value),
        riskLevel.map(value => value),
        compromisedCredentialsDetected.map(value => value)
      )
    def riskDecision
        : Option[zio.aws.cognitoidentityprovider.model.RiskDecisionType]
    def riskLevel: Option[zio.aws.cognitoidentityprovider.model.RiskLevelType]
    def compromisedCredentialsDetected: Option[WrappedBooleanType]
    def getRiskDecision: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.RiskDecisionType
    ] = AwsError.unwrapOptionField("riskDecision", riskDecision)
    def getRiskLevel: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.RiskLevelType
    ] = AwsError.unwrapOptionField("riskLevel", riskLevel)
    def getCompromisedCredentialsDetected
        : ZIO[Any, AwsError, WrappedBooleanType] = AwsError.unwrapOptionField(
      "compromisedCredentialsDetected",
      compromisedCredentialsDetected
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.EventRiskType
  ) extends zio.aws.cognitoidentityprovider.model.EventRiskType.ReadOnly {
    override val riskDecision
        : Option[zio.aws.cognitoidentityprovider.model.RiskDecisionType] = scala
      .Option(impl.riskDecision())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.RiskDecisionType.wrap(value)
      )
    override val riskLevel
        : Option[zio.aws.cognitoidentityprovider.model.RiskLevelType] = scala
      .Option(impl.riskLevel())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.RiskLevelType.wrap(value)
      )
    override val compromisedCredentialsDetected: Option[WrappedBooleanType] =
      scala
        .Option(impl.compromisedCredentialsDetected())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .WrappedBooleanType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.EventRiskType
  ): zio.aws.cognitoidentityprovider.model.EventRiskType.ReadOnly = new Wrapper(
    impl
  )
}
