package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  AttributeNameType,
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminDeleteUserAttributesRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    userAttributeNames: Iterable[AttributeNameType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest = {
    import AdminDeleteUserAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .userAttributeNames(userAttributeNames.map { item =>
        AttributeNameType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest
      .wrap(buildAwsValue())
}
object AdminDeleteUserAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest =
      zio.aws.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest(
        userPoolId,
        username,
        userAttributeNames
      )
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def userAttributeNames: List[AttributeNameType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getUserAttributeNames: ZIO[Any, Nothing, List[AttributeNameType]] =
      ZIO.succeed(userAttributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val userAttributeNames: List[AttributeNameType] = impl
      .userAttributeNames()
      .asScala
      .map { item =>
        zio.aws.cognitoidentityprovider.model.primitives.AttributeNameType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest
  ): zio.aws.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
