package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.BooleanType
import scala.jdk.CollectionConverters._
final case class SoftwareTokenMfaSettingsType(
    enabled: Option[BooleanType] = None,
    preferredMfa: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType = {
    import SoftwareTokenMfaSettingsType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType
      .builder()
      .optionallyWith(
        enabled.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        preferredMfa.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.preferredMfa)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType
      .wrap(buildAwsValue())
}
object SoftwareTokenMfaSettingsType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType =
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType(
        enabled.map(value => value),
        preferredMfa.map(value => value)
      )
    def enabled: Option[BooleanType]
    def preferredMfa: Option[BooleanType]
    def getEnabled: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getPreferredMfa: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("preferredMfa", preferredMfa)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType
  ) extends zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType.ReadOnly {
    override val enabled: Option[BooleanType] = scala
      .Option(impl.enabled())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val preferredMfa: Option[BooleanType] = scala
      .Option(impl.preferredMfa())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType
  ): zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType.ReadOnly =
    new Wrapper(impl)
}
