package zio.aws.cognitoidentityprovider.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  PaginationKeyType,
  ListResourceServersLimitType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class ListResourceServersRequest(
    userPoolId: UserPoolIdType,
    maxResults: Option[ListResourceServersLimitType] = None,
    nextToken: Option[PaginationKeyType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest = {
    import ListResourceServersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          ListResourceServersLimitType.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          PaginationKeyType.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListResourceServersRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListResourceServersRequest
      .wrap(buildAwsValue())
}
object ListResourceServersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListResourceServersRequest =
      zio.aws.cognitoidentityprovider.model.ListResourceServersRequest(
        userPoolId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def maxResults: Option[ListResourceServersLimitType]
    def nextToken: Option[PaginationKeyType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getMaxResults: ZIO[Any, AwsError, ListResourceServersLimitType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationKeyType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest
  ) extends zio.aws.cognitoidentityprovider.model.ListResourceServersRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val maxResults: Option[ListResourceServersLimitType] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .ListResourceServersLimitType(value)
      )
    override val nextToken: Option[PaginationKeyType] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .PaginationKeyType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest
  ): zio.aws.cognitoidentityprovider.model.ListResourceServersRequest.ReadOnly =
    new Wrapper(impl)
}
