package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.TokenModelType
import scala.jdk.CollectionConverters._
final case class GlobalSignOutRequest(accessToken: TokenModelType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest = {
    import GlobalSignOutRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest
      .builder()
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GlobalSignOutRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GlobalSignOutRequest
      .wrap(buildAwsValue())
}
object GlobalSignOutRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.GlobalSignOutRequest =
      zio.aws.cognitoidentityprovider.model.GlobalSignOutRequest(accessToken)
    def accessToken: TokenModelType
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest
  ) extends zio.aws.cognitoidentityprovider.model.GlobalSignOutRequest.ReadOnly {
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest
  ): zio.aws.cognitoidentityprovider.model.GlobalSignOutRequest.ReadOnly =
    new Wrapper(impl)
}
