package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class EventContextDataType(
    ipAddress: Option[StringType] = None,
    deviceName: Option[StringType] = None,
    timezone: Option[StringType] = None,
    city: Option[StringType] = None,
    country: Option[StringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.EventContextDataType = {
    import EventContextDataType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.EventContextDataType
      .builder()
      .optionallyWith(ipAddress.map(value => value: java.lang.String))(
        _.ipAddress
      )
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .optionallyWith(city.map(value => value: java.lang.String))(_.city)
      .optionallyWith(country.map(value => value: java.lang.String))(_.country)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.EventContextDataType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.EventContextDataType
      .wrap(buildAwsValue())
}
object EventContextDataType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.EventContextDataType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.EventContextDataType =
      zio.aws.cognitoidentityprovider.model.EventContextDataType(
        ipAddress.map(value => value),
        deviceName.map(value => value),
        timezone.map(value => value),
        city.map(value => value),
        country.map(value => value)
      )
    def ipAddress: Option[StringType]
    def deviceName: Option[StringType]
    def timezone: Option[StringType]
    def city: Option[StringType]
    def country: Option[StringType]
    def getIpAddress: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getDeviceName: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getTimezone: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getCity: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("city", city)
    def getCountry: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("country", country)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.EventContextDataType
  ) extends zio.aws.cognitoidentityprovider.model.EventContextDataType.ReadOnly {
    override val ipAddress: Option[StringType] =
      scala.Option(impl.ipAddress()).map(value => value: StringType)
    override val deviceName: Option[StringType] =
      scala.Option(impl.deviceName()).map(value => value: StringType)
    override val timezone: Option[StringType] =
      scala.Option(impl.timezone()).map(value => value: StringType)
    override val city: Option[StringType] =
      scala.Option(impl.city()).map(value => value: StringType)
    override val country: Option[StringType] =
      scala.Option(impl.country()).map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.EventContextDataType
  ): zio.aws.cognitoidentityprovider.model.EventContextDataType.ReadOnly =
    new Wrapper(impl)
}
