package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  SESConfigurationSet,
  StringType,
  EmailAddressType,
  ArnType
}
import scala.jdk.CollectionConverters._
final case class EmailConfigurationType(
    sourceArn: Option[ArnType] = None,
    replyToEmailAddress: Option[EmailAddressType] = None,
    emailSendingAccount: Option[
      zio.aws.cognitoidentityprovider.model.EmailSendingAccountType
    ] = None,
    from: Option[StringType] = None,
    configurationSet: Option[SESConfigurationSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.EmailConfigurationType = {
    import EmailConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.EmailConfigurationType
      .builder()
      .optionallyWith(
        sourceArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.sourceArn)
      .optionallyWith(
        replyToEmailAddress.map(value =>
          EmailAddressType.unwrap(value): java.lang.String
        )
      )(_.replyToEmailAddress)
      .optionallyWith(emailSendingAccount.map(value => value.unwrap))(
        _.emailSendingAccount
      )
      .optionallyWith(from.map(value => value: java.lang.String))(_.from)
      .optionallyWith(
        configurationSet.map(value =>
          SESConfigurationSet.unwrap(value): java.lang.String
        )
      )(_.configurationSet)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.EmailConfigurationType
      .wrap(buildAwsValue())
}
object EmailConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.EmailConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.EmailConfigurationType =
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType(
        sourceArn.map(value => value),
        replyToEmailAddress.map(value => value),
        emailSendingAccount.map(value => value),
        from.map(value => value),
        configurationSet.map(value => value)
      )
    def sourceArn: Option[ArnType]
    def replyToEmailAddress: Option[EmailAddressType]
    def emailSendingAccount
        : Option[zio.aws.cognitoidentityprovider.model.EmailSendingAccountType]
    def from: Option[StringType]
    def configurationSet: Option[SESConfigurationSet]
    def getSourceArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getReplyToEmailAddress: ZIO[Any, AwsError, EmailAddressType] =
      AwsError.unwrapOptionField("replyToEmailAddress", replyToEmailAddress)
    def getEmailSendingAccount: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EmailSendingAccountType
    ] = AwsError.unwrapOptionField("emailSendingAccount", emailSendingAccount)
    def getFrom: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("from", from)
    def getConfigurationSet: ZIO[Any, AwsError, SESConfigurationSet] =
      AwsError.unwrapOptionField("configurationSet", configurationSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.EmailConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly {
    override val sourceArn: Option[ArnType] = scala
      .Option(impl.sourceArn())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val replyToEmailAddress: Option[EmailAddressType] = scala
      .Option(impl.replyToEmailAddress())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.EmailAddressType(value)
      )
    override val emailSendingAccount: Option[
      zio.aws.cognitoidentityprovider.model.EmailSendingAccountType
    ] = scala
      .Option(impl.emailSendingAccount())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.EmailSendingAccountType
          .wrap(value)
      )
    override val from: Option[StringType] =
      scala.Option(impl.from()).map(value => value: StringType)
    override val configurationSet: Option[SESConfigurationSet] = scala
      .Option(impl.configurationSet())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .SESConfigurationSet(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.EmailConfigurationType
  ): zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly =
    new Wrapper(impl)
}
